#ifndef IncPARSEXML
#define IncPARSEXML

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
using namespace std;

struct CSNSgeometry{
        float ori[6];
        string shape;
        float size[3];
};

struct CSNSse{
        string seName;
        string name;
        string type;
};

struct CSNSsam{
        string chemical_formula;
        string name;
        string type;
        string situation;
        float distance[3];
        float density;
        float mass;
        CSNSgeometry geometry;
};

struct CSNSsource{
        string name;
        string type;
        string probe;
        float frequency;
        float power;
};

struct CSNSmoderator{
        string type;
        float distance[3];
        float temperature;
};

struct CSNSbs{
        CSNSgeometry geometry;
        float distance[3];
        string status;
};

struct CSNSaperture{
        string apertureName;
        CSNSgeometry geometry;
        float distance[3];
};

struct CSNSdc{
        string dcName;
        float phase;
        float slitAngle;
        float distance[3];
        float rotationSpeed;
};

struct CSNSlogs{
    public:
        std::vector<string> proton_charge;
        std::vector<string> disk_chopper_phase1;
        std::vector<string> sample_electric_field;
        std::vector<string> sample_magnetic_field;
        std::vector<string> sample_pressure;
        std::vector<string> sample_environment_temperature;
};

struct CSNSbank{
    public:
        string bankName;
        float distance[3];
        int * pid;
};

class ParseXML {
    public:

        ParseXML(string filename)
        {
            TiXmlDocument *doc=new TiXmlDocument(filename.c_str());
            doc->LoadFile();
            if (doc==NULL)
                cout<<"error: no such xml file!"<<endl;
            else
                root=doc->RootElement();       
        }

       // ~ParseXML();
        //Config(string configFile, char** envp = 0);
        //~Config();
        map<string, string> getPublic();
        CSNSsam getSample();
        CSNSsource getSource();
        CSNSmoderator getModerator();
        vector<CSNSse> getSE();
        CSNSbs getBS();
        vector<CSNSaperture> getAperture();
        vector<CSNSdc> getDC();
        CSNSlogs getLogs();
        //vector<CSNSdet> getDetector();
        vector<string> getBankName();
        void getBankDistance(const char* bankName, float distance[]);
        vector<CSNSbank> getBankInfo();
/*
        map<string, string> getPublic(TiXmlDocument *doc);
        CSNSsam getSample(TiXmlDocument *doc);
        CSNSsource getSource(TiXmlDocument *doc);
        CSNSmoderator getModerator(TiXmlDocument *doc);
        vector<CSNSse> getSE(TiXmlDocument *doc);
        CSNSbs getBS(TiXmlDocument *doc);
        vector<CSNSaperture> getAperture(TiXmlDocument *doc);
        vector<CSNSdc> getDC(TiXmlDocument *doc, const char* name1, const char* name2);
        CSNSlogs getLogs(TiXmlDocument *doc);
        vector<CSNSdet> getDetector(TiXmlDocument *doc);
        CSNSgeometry getGeometry(TiXmlDocument *doc, const char* name);
        void getDistance(TiXmlDocument *doc, const char* name, float distance[]);
        TiXmlDocument *loadFile(string filename);    
*/
    private:
        TiXmlElement *root;

        // private constructor for sub groups
        //Config(string name, string parentDebugInfo);

        //get node point by special name and attr 
        bool getNode(TiXmlElement *tree,TiXmlElement * &destNode, const char* nodeName);
        bool getNode(TiXmlElement *tree,TiXmlElement * &destNode,const char* nodeName, const char* attrName, const char* attrValue);
        //int getNodeNum(TiXmlElement *root, const char* nodeName, TiXmlElement * &destNode);

        CSNSgeometry getGeometry(TiXmlElement *node);
        void getDistance(TiXmlElement *node, float distance[]);
};

#endif
