#include <iostream>
#include <iomanip>
#include <locale>
#include <sstream>
#include <fstream>
#include <string>
#include <ctime>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include "nexus/NeXusFile.hpp"
#include <vector>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include "log.h"
#include "config.h"
#include "r2n.h"

using namespace std;

const uint32_t PULSE_NUM_0 = 89;
const uint32_t X_PID_M = 16;
const uint32_t Y_PID_M = 16;
const uint32_t PIXEL_NUM_M = X_PID_M*Y_PID_M;
const uint32_t EVENT_NUM_M = 785;

const uint32_t X_PID = 100;
const uint32_t Y_PID = 124;
const uint32_t PIXEL_NUM = X_PID*Y_PID;
const uint32_t TIME_BIN = 35000;
int dim[1]={0}; // one dimension data , dim[0] is line number. 
int dim2D [2] = {X_PID, Y_PID};
int dim2D_M [2] = {X_PID_M, Y_PID_M};
//int dim3D[3]={X_PID,Y_PID,TIME_BIN};
//get method
//-----------------------------------------------------------------------------
void writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
  dim[0] = dataValue.size();
  char* p = (char*)dataName.data();
  status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
  status=NXopendata(fileID,p);
  status=NXputdata(fileID,dataValue.c_str());
  status=NXclosedata(fileID);
}
//-----------------------------------------------------------------------------
// if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
//text is the unit.
void writeFloatData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "0")
    {
    NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
    break;
    }
    status=NXclosedata(fileID);
}
//-----------------------------------------------------------------------------
// if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
//text is the unit.
void writeIntData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_UINT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "0")
    {
    NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
    break;
    }
    status=NXclosedata(fileID);
}
//-------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------
//chopper used it
void getFloatOrder1D(float floatOrder1D[], uint32_t size, float init, float step)
{
  for (uint32_t i = 0; i < size; i++)
      floatOrder1D[i] = init+i*step;
}
//--------------------------------------------------------------------------------------
//chopper, present_data used it
void getFloatRandom1D(float floatRandom1D[], uint32_t size, float min, float max)
{
  for(uint32_t i = 0 ; i < size; i++)
      floatRandom1D[i] = min + ((float)rand()/(float)RAND_MAX)*(max-min);
}
//--------------------------------------------------------------------------------------
/*/--------------------------------------------------------------------------------------
void getIntRandom3D(uint32_t intRandom3D[][Y_PID][TIME_BIN], uint32_t min, uint32_t max)
{
    for(uint32_t i=0; i<X_PID; i++){
        for(uint32_t j=0; j<Y_PID; j++){
            for(uint32_t k=0; k<TIME_BIN; k++){
                intRandom3D[i][j][k]=min + rand()%(max-min+1);
            }
        }
    }
}
//---------------------------------------------------------------------------------------
void getIntRandom3D_M(uint32_t intRandom3D[][Y_PID_M][TIME_BIN], uint32_t min, uint32_t max)
{
    for(uint32_t i=0; i<X_PID_M; i++){
        for(uint32_t j=0; j<Y_PID_M; j++){
            for(uint32_t k=0; k<TIME_BIN; k++){
                intRandom3D[i][j][k]=min + rand()%(max-min+1);
            }
        }
    }
}
*/
//--------------------------------------------------------------------------------------
//chopper used it
void getPulseInfo(float pulseValue[], uint32_t size)
{
  for(uint32_t i = 0; i < size; i++)
      pulseValue[i] = rand()%2;
}
//----------------------------------------------------------------------------------
//void SaveNexusFile(uint32_t* pidmap, float* tofmap, float* ptimemap, uint32_t* mmap, std::string nexusfilename){
void SaveNexusFile(uint64_t EVENT_NUM[], uint64_t PULSE_NUM[], uint64_t MON_EVE_NUM, uint64_t MON_PUL_NUM, std::vector<int64_t* > pidmap, std::vector<float* > tofmap, std::vector<int64_t* > imap, std::vector<uint64_t* > ptimemap, int64_t* mon_pidmap, float* mon_tofmap, int64_t* mon_imap, uint64_t* mon_ptimemap, std::string nexusfilename){
  std::cout << "SavenexusFile" << std::endl;
//  cout<<"EVENT_NUM in SavenexueFile: "<<EVENT_NUM<<endl;
  NXaccess mode(NXACC_CREATE5);
  NXstatus status;
  NXhandle fileID;
  uint32_t compression(NX_COMP_LZW);
  status=NXopen(nexusfilename.c_str(), mode, &fileID);

//-----------------------------------open-csns-------------------------------------------
  //enter group: csns
  status=NXmakegroup(fileID,"csns","NXentry");
  status=NXopengroup(fileID,"csns","NXentry");

  const std::string definition = "TOF";
  const std::string beamline = "BL18";
  const std::string description = "This is the first beam from CSNS";
  const std::string accelerator_run_no = "23";
  const std::string start_time = "2016-06-23T16:58:34+08:00";
  const std::string end_time = "2016-06-22T16:58:34+08:00";
  const std::string proposal_id = "CSNS-00001";
  const std::string run_no = "0000001";
  const std::string version = "1";
  const std::string instrument_name = "GPPD";
  const std::string instrument_file = "GPPD_Definition_20170321.XML";
  std::string instrument_definition = ""; 
  fstream fileidf;
  fileidf.open("/opt/shared/home/durong/gppd_reduction/GPPD_IDF.xml", std::ios::in);
  std::stringstream tmp;
  tmp<<fileidf.rdbuf();
  instrument_definition = tmp.str();
 //cout<<instrument_definition<<endl;
  fileidf.close();

  writeCharData(status, fileID, "definition", definition);
  writeCharData(status, fileID, "beamline", beamline);
  writeCharData(status, fileID, "description", description);
  writeCharData(status, fileID, "accelerator_run_no", accelerator_run_no);
  writeCharData(status, fileID, "start_time", start_time);
  writeCharData(status, fileID, "end_time", end_time);
  writeCharData(status, fileID, "proposal_id",proposal_id);
  writeCharData(status, fileID, "run_no", run_no);
  writeCharData(status, fileID, "version", version);
  writeCharData(status, fileID, "instrument_name", instrument_name);
  writeCharData(status, fileID, "instrument_file", instrument_file);
  writeCharData(status, fileID, "instrument_definition", instrument_definition);

  string text;
  //----------------------------open-csns/instrument-----------------------------------------
  status=NXmakegroup(fileID,"instrument","NXinstrument");
  status=NXopengroup(fileID,"instrument","NXinstrument");
  //----------------------------------open-csns/instrument/sample--------------------------
  //enter group: csns/instrument/sample
  status=NXmakegroup(fileID,"sample","NXsample");
  status=NXopengroup(fileID,"sample","NXsample");

  const std::string chemical_formula = "Si";
  const std::string name = "Sillicon";
  const std::string situation = "vacuum";
  const std::string type = "sample";

  writeCharData(status, fileID, "chemical_formula", chemical_formula);
  writeCharData(status, fileID, "name", name);
  writeCharData(status, fileID, "situation", situation);
  writeCharData(status, fileID, "type", type);

  const float density = 1.8; 
  const float distance = 30.0;
  const float mass = 5.0;

  dim[0] = 1;
  text = "g cm-3";
  writeFloatData(status, fileID, "density", &density, 1, dim, text);
  text = "m";
  writeFloatData(status, fileID, "distance", &distance, 1, dim, text);
  text = "g";
  writeFloatData(status, fileID, "mass", &mass, 1, dim, text);

  //-----------------------------open-csns/instrument/sample/geometry----------------------
  //enter group: csns/instrument/sample/geometry
  status=NXmakegroup(fileID,"geometry","NXgeometry");
  status=NXopengroup(fileID,"geometry","NXgeometry");

  //-----------------------------open-csns/instrument/sample/geometry/shape-------------------
  //enter group: csns/instrument/sample/geometry/shape
  status=NXmakegroup(fileID,"shape","NXshape");
  status=NXopengroup(fileID,"shape","NXshape");

  const std::string shape = "nxcylinder";
  writeCharData(status, fileID, "shape", shape);

  float size[5] = {0.01,0.1,0.0,1.0,0.0};
  dim[0] = 5;
  text = "m";
  writeFloatData(status, fileID, "size", size, 1, dim, text);

  NXclosegroup(fileID);
  //------------------------close-csns/instrument/sample/geometry/shape----------------------
  NXclosegroup(fileID);
  //--------------------------close-csns/instrument/sample/geometry----------------------
  NXclosegroup(fileID);
  //-----------------------------close-csns/instrument/sample----------------------
  //-----------------------------open-csns/instrument/bank----------------------
  std::vector<string> bankGroup;
  int bankNum = 8;
  for(int i = 0; i< bankNum; i++){
      string str1 = static_cast<ostringstream*>(&(ostringstream()<<i))->str();
      bankGroup.push_back("bank"+str1);
  }
  std::vector<string>::iterator it_bank;
 // CSNSbank bank0;
  int ii = 0;
  for (it_bank = bankGroup.begin(); it_bank != bankGroup.end(); it_bank++)
  {
   const char *str_bank = (*it_bank).c_str(); 
   uint64_t evt_num = EVENT_NUM[ii];
    uint64_t pul_num = PULSE_NUM[ii];
  status = NXmakegroup(fileID, str_bank,"NXdetector");
  status = NXopengroup(fileID, str_bank,"NXdetector");
  //add azimuthal_angle
  float azimuthalAngle [X_PID][Y_PID];
  for(int i = 0 ; i<X_PID; i++){
      for(int j = 0; j<Y_PID; j++){
          azimuthalAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
      }
  }
  text = "degree";
  writeFloatData(status, fileID, "azimuthal_angle", *azimuthalAngle, 2, dim2D, text);
  //add distance 
  float distance [X_PID][Y_PID];
  for(int i = 0 ; i<X_PID; i++){
      for(int j = 0; j<Y_PID; j++){
          distance[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
      }
  }
  text = "m";
  writeFloatData(status, fileID, "distance", *distance, 2, dim2D, text);
  
  //add event_pixel_id
  int64_t eventPixelId [evt_num];
  int64_t *evpid = pidmap[ii];
  for (int64_t i = 0; i<evt_num; i++)
  {
      eventPixelId[i]=evpid[i];
  }
  dim[0] = evt_num;
  status=NXmakedata(fileID,"event_pixel_id",NX_INT64,1,dim);
  status=NXopendata(fileID,"event_pixel_id");
  status=NXputdata(fileID,(void*)eventPixelId);
  status=NXclosedata(fileID);
   
  //add event_time_of_flight
  float eventTimeOfFlight [evt_num];
  float * evtof = tofmap[ii];
  for (uint32_t i = 0; i<evt_num; i++)
  {
      eventTimeOfFlight[i]=evtof[i];
  }  
  writeFloatData(status, fileID, "event_time_of_flight", eventTimeOfFlight, 1, dim, "microsecond");
  //add event_index
  int64_t eventIndex [pul_num];
  int64_t * evi = imap[ii];
  for(int64_t i =0; i<pul_num; i++)
  {
      eventIndex[i] = evi[i];
  }
  dim[0] = pul_num;
  status=NXmakedata(fileID,"event_index",NX_INT64,1,dim);
  status=NXopendata(fileID,"event_index");
  status=NXputdata(fileID,(void*)eventIndex);
  status=NXclosedata(fileID);
  //add event_pulse_time
  uint64_t eventPulseTime[pul_num];
  uint64_t * evptime = ptimemap[ii];
  for (uint32_t i = 0; i<pul_num; i++){
      eventPulseTime[i] = evptime[i];
  }
  status=NXmakedata(fileID,"event_pulse_time",NX_UINT64,1,dim);
  status=NXopendata(fileID,"event_pulse_time");
  status=NXputdata(fileID,(void*)eventPulseTime);
  text = "nanosecond";
  NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
  status=NXclosedata(fileID);

  //add loacal_name  
  string local_name = "backward0";
  writeCharData(status, fileID, "local_name", local_name);
  //add pixel_id 
  int64_t pixelId [X_PID][Y_PID];
  int64_t _nm = 0; 
  for (int64_t i=0; i<X_PID; i++){
      for(int64_t j=0; j<Y_PID; j++) {
          pixelId[i][j] = _nm;
          _nm++;
      }
  }
  status=NXmakedata(fileID,"pixel_id",NX_INT64,2,dim2D);
  status=NXopendata(fileID,"pixel_id");
  status=NXputdata(fileID,(void*)pixelId);
  status=NXclosedata(fileID);
  //add polar_angle
  float polarAngle [X_PID][Y_PID];
  for(uint32_t i = 0 ; i<X_PID; i++){
      for(uint32_t j = 0; j<Y_PID; j++){
          polarAngle[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(100.0-0.0);
      }
  }
  text = "degree";
  writeFloatData(status, fileID, "polar_angle", *polarAngle, 2, dim2D, text);
  //add spectrum_index
  uint32_t spectrumIndex [PIXEL_NUM];
  for (uint32_t i = 0; i<PIXEL_NUM; i++)
  {
      spectrumIndex [i]= i;
  }
  dim[0] = PIXEL_NUM;
  status=NXmakedata(fileID,"spectrum_index",NX_UINT32,1,dim);
  status=NXopendata(fileID,"spectrum_index");
  status=NXputdata(fileID,(void*)spectrumIndex);
  status=NXclosedata(fileID);
  //add time_of_flight
  uint32_t timeBin[TIME_BIN];
  for (uint32_t i = 0; i<TIME_BIN; i++)
  {
      timeBin [i]= i*8+5000;
  }
  dim[0] = TIME_BIN;
  writeIntData(status, fileID, "time_of_flight", timeBin, 1, dim, "microsecond");
//  status=NXmakedata(fileID,"time_of_flight",NX_INT32,1,dim);
//  status=NXopendata(fileID,"time_of_flight");
//  status=NXputdata(fileID,(void*)timeBin);
//  text = "microsecond";
//  NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "3";
//  NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "Time Of Flight(s)";
//  NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "3";
//  NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "Time Of Flight (s)";
//  NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "1";
//  NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  status=NXclosedata(fileID);
  //add x_pixel_offset
  float xPixelOffset[X_PID];
  for (uint32_t i = 0; i < X_PID; i++)
  { 
      xPixelOffset[i] = 0.0+i*5.0;
  }
  dim[0] = X_PID;
  text = "m";
  writeFloatData(status, fileID, "x_pixle_offset", xPixelOffset, 1, dim, text);
//  text = "1";
//  NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "x pixel offset";
//  NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "1";
//  NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  status=NXclosedata(fileID);

  //add x_pixel_size
  float xPixelSize[X_PID][Y_PID];
  for(uint32_t i = 0 ; i<X_PID; i++){
      for(uint32_t j = 0; j<Y_PID; j++){
          xPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
      }
  }
  text = "m";
  writeFloatData(status, fileID, "x_pixle_size", *xPixelSize, 2, dim2D, text);
  //add y_pixel_offset
  float yPixelOffset[Y_PID];
  for (uint32_t i = 0; i < Y_PID; i++)
  { 
      yPixelOffset[i] = 0.0+i*10.0;
  }
  dim[0] = Y_PID;
  text = "m";
  writeFloatData(status, fileID, "y_pixle_offset", yPixelOffset, 1, dim, text);
//  text = "2";
//  NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "y pixel offset";
 // NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
 // text = "1";
 // NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  status=NXclosedata(fileID);
  //add y_pixel_size
  float yPixelSize[X_PID][Y_PID];
  for(uint32_t i = 0 ; i<X_PID; i++){
      for(uint32_t j = 0; j<Y_PID; j++){
          yPixelSize[i][j] = 0.0 + ((float)rand()/(float)RAND_MAX)*(1.0-0.0);
      }
  }
  text = "m";
  writeFloatData(status, fileID, "y_pixle_size", *yPixelSize, 2, dim2D, text);
  //add z_pixel_offset
  float zPixelOffset = 0.0;
  dim[0] = 1;
  text = "m";
  writeFloatData(status, fileID, "z_pixel_offset", &zPixelOffset, 1, dim, text);
//  text = "3";
//  NXputattr(fileID,"axis",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "z pixel offset";
//  NXputattr(fileID,"long_name",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
//  text = "1";
//  NXputattr(fileID,"primary",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
  ii++;
  NXclosegroup(fileID);
}
  //-------------------------------close-csns/instrument/bank----------------------------------------
  //-------------------------------open-csns/instrument/monitor--------------------------------------
  //CSNSmonitor monitor0;
  status=NXmakegroup(fileID, "monitor0", "NXdetector");
  status=NXopengroup(fileID, "monitor0", "NXdetector");

  //add distance 
  float mon_distance = 10.0;  
  dim[0] = 1;
  text = "m";
  writeFloatData(status, fileID, "distance", &mon_distance, 1, dim, text);
  //add event_pixel_id
  int64_t mon_eventPixelId [MON_EVE_NUM];
  for (int64_t i = 0; i<MON_EVE_NUM; i++)
  {
      mon_eventPixelId[i]= mon_pidmap[i];
  }
  dim[0] = MON_EVE_NUM;
  status=NXmakedata(fileID,"event_pixel_id",NX_INT64,1,dim);
  status=NXopendata(fileID,"event_pixel_id");
  status=NXputdata(fileID,(void*)mon_eventPixelId);
  status=NXclosedata(fileID);
  //add event_time_of_flight
  float mon_eventTimeOfFlight [MON_EVE_NUM];
  for (uint32_t i = 0; i<MON_EVE_NUM; i++)
  {
      mon_eventTimeOfFlight[i]=mon_tofmap[i];
  }
  dim[0]= MON_EVE_NUM;
//  cout<<"the monitor event tof number is"<<MON_EVE_NUM<<endl;  
//  cout<<"the monitor event tof 2 is "<<mon_eventTimeOfFlight[1]<<endl;  
//  cout<<"the monitor event tof 4 is "<<mon_eventTimeOfFlight[3]<<endl;  
//  cout<<"the monitor event tof 5 is "<<mon_eventTimeOfFlight[4]<<endl;  
  writeFloatData(status, fileID, "event_time_of_flight", mon_eventTimeOfFlight, 1, dim, "microsecond");
 // add event_index 
  int64_t mon_eventIndex [MON_PUL_NUM];
  for(int64_t i =0; i<MON_PUL_NUM; i++)
  {
      mon_eventIndex[i] = mon_imap[i];
  }
  dim[0] = MON_PUL_NUM;
  status=NXmakedata(fileID,"event_index",NX_INT64,1,dim);
  status=NXopendata(fileID,"event_index");
  status=NXputdata(fileID,(void*)mon_eventIndex);
  status=NXclosedata(fileID);
  //add event_pulse_time
  uint64_t mon_eventPulseTime[MON_PUL_NUM];
//  uint64_t * evptime = ptimemap[ii];
  for (uint64_t i = 0; i<MON_PUL_NUM; i++){
      mon_eventPulseTime[i] = mon_ptimemap[i];
  }
  status=NXmakedata(fileID,"event_pulse_time",NX_UINT64,1,dim);
  status=NXopendata(fileID,"event_pulse_time");
  status=NXputdata(fileID,(void*)mon_eventPulseTime);
  text = "nanosecond";
  NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
  status=NXclosedata(fileID);

  //add data
//  uint32_t monitorData [TIME_BIN];
//  for (uint32_t i = 0; i<TIME_BIN; i++)
//  {
//      monitorData[i] = mmap[i];
//  }
//  dim[0] = TIME_BIN;
//writeIntData(status, fileID, "data", monitorData, 1, dim, "0");

  NXclosegroup(fileID);
  //-----------------------------close-csns/instrument/monitor-------------------------------
  //------------------------------open-csns/instrument/disk_chopper-------------------------
  CSNSdiskchopper disk_chopper0;
  CSNSdiskchopper disk_chopper1;
  status = NXmakegroup(fileID, "disk_chopper0", "NXdisk_chopper");
  status = NXopengroup(fileID, "disk_chopper0", "NXdisk_chopper");
  disk_chopper0.phase = 10.0;
  disk_chopper0.slitAngle = 30.0;
  disk_chopper0.distance = 9.0;
  disk_chopper0.rotationSpeed = 25.0;

  dim[0]=1; 
  text = "degree";
  writeFloatData(status, fileID, "phase", &disk_chopper0.phase, 1, dim, text);
  text = "degree";
  writeFloatData(status, fileID, "slit_angle", &disk_chopper0.slitAngle, 1, dim, text);
  text = "m";
  writeFloatData(status, fileID, "distance", &disk_chopper0.distance, 1, dim, text);
  text = "Hz";
  writeFloatData(status, fileID, "rotation_speed", &disk_chopper0.rotationSpeed, 1, dim, text);
 
  NXclosegroup(fileID);

  status = NXmakegroup(fileID, "disk_chopper1", "NXdisk_chopper");
  status = NXopengroup(fileID, "disk_chopper1", "NXdisk_chopper");
  disk_chopper1.phase = 10.0;
  disk_chopper1.slitAngle = 30.0;
  disk_chopper1.distance = 19.0;
  disk_chopper1.rotationSpeed = 12.5;

  text = "degree";
  writeFloatData(status, fileID, "phase", &disk_chopper1.phase, 1, dim, text);
  text = "degree";
  writeFloatData(status, fileID, "slit_angle", &disk_chopper1.slitAngle, 1, dim, text);
  text = "m";
  writeFloatData(status, fileID, "distance", &disk_chopper1.distance, 1, dim, text);
  text = "Hz";
  writeFloatData(status, fileID, "rotation_speed", &disk_chopper1.rotationSpeed, 1, dim, text);

  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/disk_chopper---------------------------------
  //--------------------------------open-csns/instrument/aperture1---------------------------------
  status=NXmakegroup(fileID,"aperture1","NXaperture");
  status=NXopengroup(fileID,"aperture1","NXaperture");

  float offset[2]={0.01,0.01};
  dim[0]=2; 
  text = "m";
  writeFloatData(status, fileID, "offset", offset, 1, dim, text);
  //--------------------------------open-csns/instrument/aperture1/geometry---------------------------
  status=NXmakegroup(fileID,"geometry","NXgeometry");
  status=NXopengroup(fileID,"geometry","NXgeometry");
  //--------------------------------open-csns/instrument/aperture1/geometry/orientation-----------------
  status=NXmakegroup(fileID,"orientation","NXorientation");
  status=NXopengroup(fileID,"orientation","NXorientation");

  float value_ori[6]={1.0,0.0,0.0,1.0,1.0,0.0};
  dim[0]=6; 
  text = "0";
  writeFloatData(status, fileID, "value", value_ori, 1, dim, text);
  NXclosegroup(fileID);
  //------------------------close-csns/instrument/aperture1/geometry/orientation-----------------------
  //------------------------open-csns/instrument/aperture1/geometry/shape-----------------------
  status=NXmakegroup(fileID,"shape","NXshape");
  status=NXopengroup(fileID,"shape","NXshape");

  float size_shape[3]={0.04,-1.0,0.1};
  dim[0]=3;
  text = "m";
  writeFloatData(status, fileID, "size", size_shape, 1, dim, text);

  const std::string shape_shape = "nxbox";
  writeCharData(status, fileID, "shape", shape_shape);

  NXclosegroup(fileID); 
  //------------------------close-csns/instrument/aperture1/geometry/shape-----------------------
  //------------------------open-csns/instrument/aperture1/geometry/translation--------------------
  status=NXmakegroup(fileID,"translation","NXtranslation");
  status=NXopengroup(fileID,"translation","NXtranslation");

  float distance_trans[3]={0.0,0.0,10.0};
  dim[0]=3;
  text = "m";
  writeFloatData(status, fileID, "distance", distance_trans, 1, dim, text);
  NXclosegroup(fileID);
  //------------------------close-csns/instrument/aperture1/geometry/translation--------------------
  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/aperture1/geometry---------------------------
  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/aperture1---------------------------------
  //--------------------------------open-csns/instrument/flipper1---------------------------------
  status=NXmakegroup(fileID,"flipper1","NXflipper");
  status=NXopengroup(fileID,"flipper1","NXflipper");

  const std::string type_flip="coil";
  writeCharData(status, fileID, "type", type_flip);

  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/flipper1---------------------------------
  //--------------------------------open-csns/instrument/moderator---------------------------------
  status=NXmakegroup(fileID,"moderator","NXmoderator");
  status=NXopengroup(fileID,"moderator","NXmoderator");

  const std::string type_mod="Liquid H2";
  const std::string poison_material="NO";
  writeCharData(status, fileID, "type", type_mod);
  writeCharData(status, fileID, "poison_material", poison_material);

  const float distance_mod=30.0;
  dim[0]=1;
  text = "m";
  writeFloatData(status, fileID, "distance", &distance_mod, 1, dim, text);

  const float temperature_mod = 20.0;
  text = "K";
  writeFloatData(status, fileID, "temperature", &temperature_mod, 1, dim, text);

  const uint32_t coupled_mod = 0;
  status=NXmakedata(fileID, "coupled", NX_UINT32, 1, dim);
  status=NXopendata(fileID, "coupled");
  status=NXputdata(fileID, &coupled_mod);
  status=NXclosedata(fileID);

  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/moderator---------------------------------
  //--------------------------------open-csns/instrument/polarizer1---------------------------------
  status=NXmakegroup(fileID,"polarizer1","NXpolarizer");
  status=NXopengroup(fileID,"polarizer1","NXpolarizer");

  const std::string type_polar="crystal";
  writeCharData(status,fileID,"type",type_polar);

  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/polarizer1---------------------------------
  //--------------------------------open-csns/instrument/sample_environment---------------------------------
  status=NXmakegroup(fileID,"sample_environment","NXenvironment");
  status=NXopengroup(fileID,"sample_environment","NXenvironment");

  const std::string name_se="OC100 011";
  const std::string type_se="OC/100";

  writeCharData(status,fileID,"name",name_se);
  writeCharData(status,fileID,"type",type_se);

  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/sample_environment---------------------------------
  //--------------------------------open-csns/instrument/source---------------------------------
  status=NXmakegroup(fileID,"source","NXsource");
  status=NXopengroup(fileID,"source","NXsource");

  const std::string name_source="CSNS";
  const std::string type_source="Spallation Neutron Source";
  const std::string probe_source="Neutron";
  writeCharData(status,fileID,"name",name_source);
  writeCharData(status,fileID,"type",type_source);
  writeCharData(status,fileID,"probe",probe_source);

  const float frequency_source = 25.0;  
  const float power_source =-1.0;

  dim[0]=1;
  text = "Hz";
  writeFloatData(status, fileID, "frequency", &frequency_source, 1, dim, text);
  text = "W";
  writeFloatData(status, fileID, "power", &power_source, 1, dim, text);

  NXclosegroup(fileID);
  //--------------------------------close-csns/instrument/source---------------------------------
  NXclosegroup(fileID);
  //-----------------------------close-csns/instrument----------------------
  //----------------------------open-csns/logs-----------------------------------
  //open group: csns/logs
  status=NXmakegroup(fileID,"logs","NXcollection");
  status=NXopengroup(fileID,"logs","NXcollection");

  //get chopperPhase and chopperSpeed 
  float pulseTime[PULSE_NUM_0];  
  float pulseValue[PULSE_NUM_0];
  float chopperSpeedValue[PULSE_NUM_0];
  getFloatOrder1D(pulseTime, PULSE_NUM_0, 0.0, 0.04);
  getPulseInfo(pulseValue, PULSE_NUM_0);
  getFloatRandom1D(chopperSpeedValue, PULSE_NUM_0, 25.0, 26.0);
  //--------------------------open-csns/logs/disk_chopper0-----------------------------
  //create chopper group

  std::vector<string> chopperGroup;
  uint32_t chopperNum = 2;
  for (uint32_t k = 0; k<chopperNum; k++)
  {
      string str1 = static_cast<ostringstream*>(&(ostringstream()<<k))->str();
      chopperGroup.push_back("disk_chopper"+str1);
  }
  std::vector<string>::iterator it_chopper;
  for(it_chopper = chopperGroup.begin(); it_chopper!= chopperGroup.end();it_chopper++)
  {
      char* pm = (char*)(*it_chopper).data();
      status=NXmakegroup(fileID, pm,"NXcollection");
      status=NXopengroup(fileID, pm,"NXcollection");
      //--------------------------open-csns/logs/disk_chopper0/phase-----------------------------
      //open group: csns/logs/disk_chopper0/phase
      status=NXmakegroup(fileID,"phase","NXlog");
      status=NXopengroup(fileID,"phase","NXlog");

      dim[0] = 89;
      text = "s";
      writeFloatData(status, fileID, "time", pulseTime, 1, dim, text);
      text = "0";
      writeFloatData(status, fileID, "value", pulseValue, 1, dim, text);
 
      NXclosegroup(fileID);
      //---------------------------------close-csns/logs/disk_chopper/phase--------------------
      //--------------------------open-csns/logs/disk_chopper/speed-----------------------------
      //open group: csns/logs/disk_chopper/speed
      status=NXmakegroup(fileID,"speed","NXlog");
      status=NXopengroup(fileID,"speed","NXlog");

      writeFloatData(status, fileID, "time", pulseTime, 1, dim, "s");
      writeFloatData(status, fileID, "value", chopperSpeedValue, 1, dim, "Hz");

      NXclosegroup(fileID);
      //--------------------------------close-csns/logs/disk_chopper/speed--------------------
      NXclosegroup(fileID);
      //--------------------------------close-csns/logs/disk_chopper--------------------
  }
  //--------------------------open-csns/logs/good_frame-----------------------------
  //  //open group: csns/logs/good_frame
  status=NXmakegroup(fileID,"good_frame","NXlog");
  status=NXopengroup(fileID,"good_frame","NXlog");

  text = "s";
  writeFloatData(status, fileID, "time", pulseTime, 1, dim, text);
  text = "0";
  writeFloatData(status, fileID, "value", pulseValue, 1, dim, text);

  NXclosegroup(fileID);
  //-------------------------------close-csns/logs/good_frame---------------------------------------

  //--------------------------open-csns/logs/proton_charge-----------------------------
  //open group: csns/logs/proton_charge
  status=NXmakegroup(fileID,"proton_charge","NXlog");
  status=NXopengroup(fileID,"proton_charge","NXlog");

  text = "s";
  writeFloatData(status, fileID, "time", pulseTime, 1, dim, text);
  text = "pC";
  writeFloatData(status, fileID, "value", pulseValue, 1, dim, text);
  //need to generate proton charge value!!! it is not pulse value!!!

  NXclosegroup(fileID);
  //-------------------------------close-csns/logs/proton_charge---------------------------------------
  //--------------------------open-csns/logs/sample_environment-----------------------------
  //open group: csns/logs/sample_environment
  status=NXmakegroup(fileID,"sample_environment","NXcollection");
  status=NXopengroup(fileID,"sample_environment","NXcollection");

  float time[2] = {0.0, 25.0};
  float value[2] = {0.0, 15.0};

  //-----------------------open-csns/logs/sample_environment/electric_field-----------------------------
  //open group: csns/logs/sample_environment/electric_field
  status=NXmakegroup(fileID,"electric_field","NXlog");
  status=NXopengroup(fileID,"electric_field","NXlog");

  dim[0] = 2;
  text = "s";
  writeFloatData(status, fileID, "time", time, 1, dim, text);
  text = "V m-1";
  writeFloatData(status, fileID, "value", value, 1, dim, text);

  NXclosegroup(fileID);
  //--------------------------close-csns/logs/sample_environment/electrin_field---------------------------------------
  //-----------------------open-csns/logs/sample_environment/magnetic_field-----------------------------
  status=NXmakegroup(fileID,"magnetic_field","NXlog");
  status=NXopengroup(fileID,"magnetic_field","NXlog");

  text = "s";
  writeFloatData(status, fileID, "time", time, 1, dim, text);
  text = "T";
  writeFloatData(status, fileID, "value", value, 1, dim, text);
  
  NXclosegroup(fileID);
  //--------------------------close-csns/logs/sample_environment/magnetic_field---------------------------------------
  //-----------------------open-csns/logs/sample_environment/pressure-----------------------------
  status=NXmakegroup(fileID,"pressure","NXlog");
  status=NXopengroup(fileID,"pressure","NXlog");

  text = "s";
  writeFloatData(status, fileID, "time", time, 1, dim, text);
  text = "Pa";
  writeFloatData(status, fileID, "value", value, 1, dim, text);

  NXclosegroup(fileID);
  //-------------------------------close-csns/logs/sample_environment/pressure---------------------------------------
  //-----------------------open-csns/logs/sample_environment/temperature-----------------------------
  status=NXmakegroup(fileID,"temperature","NXlog");
  status=NXopengroup(fileID,"temperature","NXlog");

  text = "s";
  writeFloatData(status, fileID, "time", time, 1, dim, text);
  text = "K";
  writeFloatData(status, fileID, "value", value, 1, dim, text);

  NXclosegroup(fileID);
  //---------------close-csns/logs/sample_environment/temperature---------------------------------------
  NXclosegroup(fileID);
  //-------------------------close-csns/logs/sample_environment---------------------------------------
  NXclosegroup(fileID);
  //--------------------------------------close-csns/logs/---------------------------------------
  //-------------------------------------open-csns/process/-------------------------------
  status=NXmakegroup(fileID,"process","NXprocess");
  status=NXopengroup(fileID,"process","NXprocess");
  //-------------------------------------open-csns/process/process1-------------------------------
  CSNSprocess process1;
  status=NXmakegroup(fileID,"process1","NXnote");
  status=NXopengroup(fileID,"process1","NXnote");

  process1.author="Li Si";
  process1.data="GPPD_builder_1.0.py -l 1 -c 6Li.dat -i BLxx_xxxx_0000001_001.raw";
  process1.date="2015-05-21T16:49:36+08:00";
  process1.description="This is event data builder.";

  writeCharData(status,fileID,"author",process1.author);
  writeCharData(status,fileID,"data",process1.data);
  writeCharData(status,fileID,"date",process1.date);
  writeCharData(status,fileID,"description",process1.description);

  NXclosegroup(fileID);
  //--------------------------close-csns/process/process1-------------------------------
  NXclosegroup(fileID);
  //-------------------------------------close-csns/process/-------------------------------
  //-------------------------------open-csns/present_data------------------------------------
  status=NXmakegroup(fileID,"present_data","NXdata");
  status=NXopengroup(fileID,"present_data","NXdata");

  const std::string plot_pres="data1,data2,data3:data3_error";
  const std::string title_pres="Events Distribution";
  const std::string type_pres="line";
  writeCharData(status,fileID,"plot",plot_pres);
  writeCharData(status,fileID,"title",title_pres);
  writeCharData(status,fileID,"type",type_pres);

  uint32_t data1_size=124;
  uint32_t data2_size=56;

  float data1[data1_size];
  float data2[data2_size];
  float data3[data1_size*data2_size];
  float data3_error[data1_size*data2_size];
  getFloatRandom1D(data1, data1_size, 0.0, 100.0);
  getFloatRandom1D(data2, data2_size, 0.0, 50.0);
  getFloatRandom1D(data3, data1_size*data2_size, 0.0, 30.0);
  getFloatRandom1D(data3_error, data1_size*data2_size, 0.0, 1.0);

  dim[0] = data1_size;
  text = "m";
  writeFloatData(status, fileID, "data1", data1, 1, dim, text);
  dim[0] = data2_size;
  text = "m";
  writeFloatData(status, fileID, "data2", data2, 1, dim, text);
  dim[0] = data1_size*data2_size;
  text = "counts";
  writeFloatData(status, fileID, "data3", data3, 1, dim, text);
  dim[0] = data1_size*data2_size;
  text = "0";
  writeFloatData(status, fileID, "data3_error", data3_error, 1, dim, text);

  NXclosegroup(fileID);
  //-------------------------------------close-csns/present_date/-------------------------------
  //-------------------------------------------open-csns/users------------------------------------
  status=NXmakegroup(fileID,"users","NXcollection");
  status=NXopengroup(fileID,"users","NXcollection");
  //-----------------------------------------open-csns/users/user--------------------------------------
  CSNSusers user1;
  CSNSusers user2;

  status=NXmakegroup(fileID,"user1","NXuser");
  status=NXopengroup(fileID,"user1","NXuser");
  user1.address="Zhongziyuan Road No.1, Dongguan, Guangdong, China";
  user1.affiliation="IHEP";
  user1.email="tangm@ihep.ac.cn";
  user1.facility_user_id="tangm";
  user1.name="M Tang";
  user1.role="principal_investigator";
  writeCharData(status, fileID, "address", user1.address);
  writeCharData(status, fileID, "affiliation",user1.affiliation);
  writeCharData(status, fileID, "email", user1.email);
  writeCharData(status, fileID, "facility_user_id", user1.facility_user_id);
  writeCharData(status, fileID, "name", user1.name);
  writeCharData(status, fileID, "role", user1.role);
  NXclosegroup(fileID);

  status=NXmakegroup(fileID,"user2","NXuser");
  status=NXopengroup(fileID,"user2","NXuser");
  user2.address="Zhongziyuan Road No.1, Dongguan, Guangdong, China";
  user2.affiliation="IHEP";
  user2.email="durong@ihep.ac.cn";
  user2.facility_user_id="dur";
  user2.name="R Du";
  user2.role="investigator";
  writeCharData(status, fileID, "address", user2.address);
  writeCharData(status, fileID, "affiliation",user2.affiliation);
  writeCharData(status, fileID, "email", user2.email);
  writeCharData(status, fileID, "facility_user_id", user2.facility_user_id);
  writeCharData(status, fileID, "name", user2.name);
  writeCharData(status, fileID, "role", user2.role);
  NXclosegroup(fileID);
  //-------------------------------------------close-csns/users/user---------------------------------
  NXclosegroup(fileID);
  //-------------------------------------------close-csns/users-----------------------------------------
  //-------------------------------open-csns/event_data------------------------------------
  status=NXmakegroup(fileID,"event_data","NXcollection");
  status=NXopengroup(fileID,"event_data","NXcollection");
  NXclosegroup(fileID);
  for (it_bank = bankGroup.begin(); it_bank != bankGroup.end(); it_bank++)
  {
   std::string bank_name = *it_bank;

  //---------------------------------open-csns/event_data/bank----------------------------
  //create link
  NXlink eventIndexLink;
  NXlink eventPixelIdLink;
  NXlink eventPulseTimeLink;
  NXlink eventTimeOfFlightLink;
   string path = "/csns/instrument/"+bank_name;
 // string path = "/csns/instrument/bank0";
  string pathEventIndex = path+"/event_index";
  string pathEventPixelId = path+"/event_pixel_id";
  string pathEventPulseTime = path+"/event_pulse_time";
  string pathEventTimeOfFlight = path+"/event_time_of_flight";
  string pathEventData="/csns/event_data";

  status=NXopenpath(fileID, pathEventIndex.c_str());
  status=NXgetdataID(fileID, &eventIndexLink);
  status=NXopenpath(fileID, pathEventPixelId.c_str());
  status=NXgetdataID(fileID, &eventPixelIdLink);
  status=NXopenpath(fileID, pathEventPulseTime.c_str());
  status=NXgetdataID(fileID, &eventPulseTimeLink);
  status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
  status=NXgetdataID(fileID, &eventTimeOfFlightLink);

  status=NXopenpath(fileID, pathEventData.c_str());

  const char *str_bank = (*it_bank).c_str();
  status = NXmakegroup(fileID, str_bank,"NXevent_data");
  status = NXopengroup(fileID, str_bank,"NXevent_data");

//  status=NXmakegroup(fileID, "bank0", "NXevent_data");    
//  status=NXopengroup(fileID, "bank0", "NXevent_data");    

  status=NXmakelink(fileID, &eventIndexLink);
  status=NXmakelink(fileID, &eventPixelIdLink);
  status=NXmakelink(fileID, &eventPulseTimeLink);
  status=NXmakelink(fileID, &eventTimeOfFlightLink);

  NXclosegroup(fileID);
}
  //------------------------------close-csns/event_data/bank------------------------------  
  NXclosegroup(fileID);
//-------------------------------close-csns/event_data----------------------------- 
 //---------------------------open-csns-event_data/monitor-----------------------  
//create link
  NXlink mon_eventIndexLink;
  NXlink mon_eventPixelIdLink;
  NXlink mon_eventPulseTimeLink;
  NXlink mon_eventTimeOfFlightLink;
   string path = "/csns/instrument/monitor0";
  string mon_pathEventIndex = path+"/event_index";
  string mon_pathEventPixelId = path+"/event_pixel_id";
  string mon_pathEventPulseTime = path+"/event_pulse_time";
  string mon_pathEventTimeOfFlight = path+"/event_time_of_flight";
  string mon_pathEventData="/csns/event_data";

  status=NXopenpath(fileID, mon_pathEventIndex.c_str());
  status=NXgetdataID(fileID, &mon_eventIndexLink);
  status=NXopenpath(fileID, mon_pathEventPixelId.c_str());
  status=NXgetdataID(fileID, &mon_eventPixelIdLink);
  status=NXopenpath(fileID, mon_pathEventPulseTime.c_str());
  status=NXgetdataID(fileID, &mon_eventPulseTimeLink);
  status=NXopenpath(fileID, mon_pathEventTimeOfFlight.c_str());
  status=NXgetdataID(fileID, &mon_eventTimeOfFlightLink);

  status=NXopenpath(fileID, mon_pathEventData.c_str());
  status = NXmakegroup(fileID, "monitor0","NXevent_data");
  status = NXopengroup(fileID, "monitor0","NXevent_data");

  status=NXmakelink(fileID, &mon_eventIndexLink);
  status=NXmakelink(fileID, &mon_eventPixelIdLink);
  status=NXmakelink(fileID, &mon_eventPulseTimeLink);
  status=NXmakelink(fileID, &mon_eventTimeOfFlightLink);

  NXclosegroup(fileID);
//-----------------------close-csns/event_data/monitor0--------------------------   
  NXclosegroup(fileID);
  //-----------------------------close-csns/event_data-----------------------------------
  //-----------------------------open-csns/histogram_data----------------------------------
  status=NXmakegroup(fileID,"histogram_data","NXcollection");
  status=NXopengroup(fileID,"histogram_data","NXcollection");
  NXclosegroup(fileID);
  //------------------------------open_csns/histogram_data/monitor-----------------------
/*
  NXlink TimeOfFlightLink;
  NXlink MonitorDataLink;
  string pathTimeOfFlight = "/csns/instrument/monitor0/time_of_flight";
  string pathMonitorData = "/csns/instrument/monitor0/data";
  string pathHistogramData="/csns/histogram_data";

  status=NXopenpath(fileID, pathTimeOfFlight.c_str());
  status=NXgetdataID(fileID, &TimeOfFlightLink);
  status=NXopenpath(fileID, pathMonitorData.c_str());
  status=NXgetdataID(fileID, &MonitorDataLink);

  status=NXopenpath(fileID, pathHistogramData.c_str());
  status=NXmakegroup(fileID, "monitor0", "NXdata");
  status=NXopengroup(fileID, "monitor0", "NXdata");

  status=NXmakelink(fileID, &TimeOfFlightLink);
  status=NXmakelink(fileID, &MonitorDataLink);

  NXclosegroup(fileID);
  //-----------------------------close-csns/histogram_data/monitor------------------------------
  NXclosegroup(fileID);
  //-----------------------------close-csns/histogram_data----------------------------------
*/
  NXclosegroup(fileID);
  //-------------------------------close-csns---------------------------------------
  /*-----------------------------------------------*/
  // close file
  NXclose(&fileID);
}
//--------------------------Load event data------------------------------
void LoadEventFile(int64_t* pidmap,float* tofmap, uint64_t &evtnum, std::string eventfilename)
{
    cout<<"LoadEventFile"<<endl;
    std::ifstream eventfile(eventfilename.c_str());
    std::string eventbuff;
    uint32_t n = 0;
    while(!eventfile.eof()){
        getline(eventfile,eventbuff);
        std::vector<string> substring;
        boost::split(substring, eventbuff, boost::is_any_of(";"), boost::token_compress_on);
        pidmap[n]=atoi(substring[0].c_str());
        tofmap[n]=atof(substring[1].c_str());
        n++;    
    }
    evtnum = n-1;
    eventfile.close();
}
//--------------------------Load pulse data----------------------------------
void LoadPulseFile(int64_t* imap, uint64_t* ptimemap,uint64_t &pulsenum, std::string pulsefilename)
{
    cout<<"LoadPulseFile"<<endl;
    std::ifstream pulsefile(pulsefilename.c_str());
    std::string pulsebuff;
    uint32_t n1 = 0;
    while(!pulsefile.eof()){    
        getline(pulsefile,pulsebuff);
        std::vector<string> substring;
        boost::split(substring, pulsebuff, boost::is_any_of(";"), boost::token_compress_on);
        imap[n1]= atol(substring[0].c_str());
        ptimemap[n1]=atol(substring[1].c_str());
        n1++;
    }
    pulsenum = n1-1;
    pulsefile.close();
}
//------------------------Load monitor data---------------------------------------
void LoadMonitorFile(int64_t* mon_pidmap, float* mon_tofmap, uint64_t &mon_evtnum, std::string monitorfilename)
{
    cout<<"LoadMonitorFile"<<endl;
    std::ifstream monitorfile(monitorfilename.c_str());
    std::string mon_buff;
    uint32_t n = 0;
    while(!monitorfile.eof()){
        getline(monitorfile,mon_buff);
        std::vector<string> substring;
        boost::split(substring, mon_buff, boost::is_any_of(";"), boost::token_compress_on);
       // tmap[n]=atol(substring[0].c_str());
        mon_pidmap[n]=atol(substring[0].c_str());
        mon_tofmap[n]=atof(substring[1].c_str());
        n++;
    }
    mon_evtnum = n-1;
    monitorfile.close();
}
//--------------------------------------------------------------------------------------------

int main(int argc, char *argv[])
{
    if ( argc != 2 ) {
        std::cout << "Usage: " << argv[0] << "  option.txt" << std::endl;
        return 1;
    }
    uint32_t evtnum[1];
    uint64_t EVENT_NUM[8];
    uint64_t PULSE_NUM[8];
    uint32_t TIME_BIN;
//    uint32_t *pidmap = new uint32_t[99999];
//    float *tofmap = new float[99999];
//    uint64_t *imap = new uint64_t[99999];
//    uint64_t *ptimemap = new uint64_t[99999];
    std::vector<int64_t *> pidmap;
    std::vector<float *> tofmap;
    std::vector<int64_t *> imap;
    std::vector<uint64_t *> ptimemap;
//    uint32_t *tmap = new uint32_t[99999];
//    uint64_t *mmap = new uint64_t[99999]; 
    float *mon_tofmap = new float[99999]; 
    int64_t *mon_pidmap = new int64_t[99999];
    int64_t *mon_imap = new int64_t[99999];
    uint64_t *mon_ptimemap = new uint64_t[99999];


    std::string configfile(argv[1]);
    Config* fConfig = new Config(configfile);
    std::string eventfile[8] = {"event0","event1","event2","event3","event4","event5","event6","event7"};
    std::string pulsefile[8] = {"pulse0","pulse1","pulse2","pulse3","pulse4","pulse5","pulse6","pulse7"};
    eventfile[0] = fConfig->pString("event0");
    eventfile[1] = fConfig->pString("event1");
    eventfile[2] = fConfig->pString("event2");
    eventfile[3] = fConfig->pString("event3");
    eventfile[4] = fConfig->pString("event4");
    eventfile[5] = fConfig->pString("event5");
    eventfile[6] = fConfig->pString("event6");
    eventfile[7] = fConfig->pString("event7");
    pulsefile[0] = fConfig->pString("pulse0");
    pulsefile[1] = fConfig->pString("pulse1");
    pulsefile[2] = fConfig->pString("pulse2");
    pulsefile[3] = fConfig->pString("pulse3");
    pulsefile[4] = fConfig->pString("pulse4");
    pulsefile[5] = fConfig->pString("pulse5");
    pulsefile[6] = fConfig->pString("pulse6");
    pulsefile[7] = fConfig->pString("pulse7");
    std::string monitorfile;
    std::string monitorpulsefile;
    monitorfile = fConfig->pString("monitorfile");
    monitorpulsefile = fConfig->pString("monitorpulsefile");
    std::string nexusfile     = fConfig->pString("nexusfile") ; 
    uint64_t EVE_NUM = 0;
    uint64_t PU_NUM = 0;
    uint64_t MON_PUL_NUM = 0;
    uint64_t MON_EVE_NUM = 0;
//    PULSE_NUM = 0;
    TIME_BIN = 0;
    for(int i = 0; i < 8; i++){
        int64_t *pid = new int64_t[99999];
        float *tof = new float[99999];
        int64_t *ind = new int64_t[99999];
        uint64_t *ptime = new uint64_t[99999];
        LoadEventFile(pid, tof, EVE_NUM, eventfile[i]);           
        LoadPulseFile(ind, ptime, PU_NUM, pulsefile[i]);
        EVENT_NUM[i] = EVE_NUM;
        PULSE_NUM[i] = PU_NUM;
    cout<<"EVENT_NUM after LoadEventFile: "<<EVENT_NUM[i]<<endl;
    cout<<"PULSE_NUM after LoadPulseFile: "<<PULSE_NUM[i]<<endl;
        pidmap.push_back(pid);
        tofmap.push_back(tof);
        imap.push_back(ind);
        ptimemap.push_back(ptime);
    }
        LoadMonitorFile(mon_pidmap, mon_tofmap, MON_EVE_NUM, monitorfile);
        LoadPulseFile(mon_imap, mon_ptimemap, MON_PUL_NUM, monitorpulsefile);
    //LoadEventFile(pidmap, tofmap, EVENT_NUM, eventfile);
    //LoadPulseFile(imap, ptimemap, PULSE_NUM, pulsefile);
    //LoadMonitorFile(tmap, mmap, TIME_BIN, monitorfile);
    cout<<"MON_EVE_NUM after LoadMonitorFile: "<<MON_EVE_NUM<<endl;
    SaveNexusFile(EVENT_NUM, PULSE_NUM, MON_EVE_NUM, MON_PUL_NUM, pidmap,tofmap, imap, ptimemap, mon_pidmap, mon_tofmap, mon_imap,mon_ptimemap, nexusfile);

    return 0;
}
