#ifndef IncPARSEXML
#define IncPARSEXML

#include <string>
#include <map>
#include <vector>
#include <list>
#include <tinyxml.h>
using namespace std;

/*
   ParseXML
   */

class CSNSse{
    public:
        string name;
        string type;
};

class CSNSdc{
    public:
        string phase;
        string slitAngle;
        std::vector<string> distance;
        string rotationSpeed;
};

class CSNSgeometry{
    public:
        std::vector<string> ori;
        string shape;
        std::vector<string> size;
};

class CSNSbs{
    public:
        CSNSgeometry geometry;
        std::vector<string> distance;
        string status;
};

class CSNSapeture{
    public:
        CSNSgeometry geometry;
        std::vector<string> distance;
};

class CSNSlogs{
    public:
        std::vector<string> proton_charge;
        std::vector<string> disk_chopper_phase1;
        std::vector<string> sample_electric_field;
        std::vector<string> sample_magnetic_field;
        std::vector<string> sample_pressure;
        std::vector<string> sample_environment_temperature;
};

class CSNSdetector{
    public:
        string bankName;
        map<string, string> pid;
        map<string, string> pos;
};

class ParseXML {
    public:
        //Config(string configFile, char** envp = 0);

        //~Config();

        std::vector<string> getDistance(TiXmlDocument *doc, const char* name);
        CSNSgeometry getGeometry(TiXmlDocument *doc, const char* name);

        map<string, string> getPublic(TiXmlDocument *doc);
        map<string, string> getInstrumentComponent(TiXmlDocument *doc, const char* name);
        map<string, string> getSample(TiXmlDocument *doc);
        vector<CSNSse> getSE(TiXmlDocument *doc);
        vector<CSNSdc> getDC(TiXmlDocument *doc, const char* name1, const char* name2);
        vector<CSNSapeture> getApeture(TiXmlDocument *doc, const char* name1, const char* name2);
        CSNSbs getBS(TiXmlDocument *doc, const char* name);
        CSNSlogs getLogs(TiXmlDocument *doc);

    private:
        // private constructor for sub groups
        //Config(string name, string parentDebugInfo);

        //get node point by special name and attr 
        void getNodePointerByName(TiXmlElement *root, const char* nodeName, TiXmlElement * &destNode);
        void getNodePointerByAttr(TiXmlElement *root, const char* attrName, const char* attrValue, TiXmlElement * &destNode);


};

#endif
