#include "parseXML.h"
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
using namespace std;

bool ParseXML::getNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName)
{
    TiXmlAttribute *attr;
    if(0==strcmp(nodeName, tree->Value()))
    {
        destNode=tree;
        return true;
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement()){
        if(0==strcmp(nodeName,pNode->Value()))
        {
            destNode=pNode;
            return true;
        }else
            getNode(pNode, destNode,nodeName);
    }
    return false;    
}

bool ParseXML::getNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName, const char* attrName, const char* attrValue)
{
    TiXmlAttribute *attr;
    if(0==strcmp(nodeName, tree->Value()))
    {
        for(attr=tree->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue)))
            {
                destNode=tree;
                return true;
            }
        }
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement())
    {
        if(0==strcmp(nodeName,pNode->Value()))
        {
            for(attr=pNode->FirstAttribute();attr!=NULL; attr=attr->Next())
            {
                if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue))){
                    destNode=pNode;
                    return true;
                }
            }
        }else
            getNode(pNode,destNode,nodeName,attrName,attrValue);
    }    
        return false;
}

void ParseXML::getDistance(TiXmlElement *node, float distance[])
{
    vector<string> data;
    TiXmlElement *search;
    TiXmlText *text;
    const char* str2;
    getNode(node, search, "distance");
    text=search->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data,str2,boost::is_any_of(" "), boost::token_compress_on);
    for(int i=0; i!=3; i++)
           distance[i]=atof(data[i].c_str());
}

CSNSgeometry ParseXML::getGeometry(TiXmlElement *node)
{
    CSNSgeometry data;
    vector<string> tmp;
    TiXmlElement *search, *group, *son;
    TiXmlText *text;
    const char* str;
    getNode(node, search, "NXgeometry");
    if(getNode(search, group, "NXorientation"))
    {
        if(getNode(group, son, "value"))
        {
            text=son->FirstChild()->ToText();
            str=text->Value();
            boost::split(tmp,str,boost::is_any_of(" "), boost::token_compress_on);
            for(int i =0; i!=6; i++)
                data.ori[i]=atof(tmp[i].c_str());
            tmp.clear();
        }
    }else{
        cout<<"No orientation"<<endl;
    }
    if(getNode(search, group, "NXshape"))
    {
        if(getNode(group, son, "size"))
        {
            text=son->FirstChild()->ToText();
            str=text->Value();
            boost::split(tmp,str,boost::is_any_of(" "), boost::token_compress_on);
            for(int i =0; i!=3; i++)
                data.size[i]=atof(tmp[i].c_str());
            tmp.clear();
        }
        if(getNode(group, son, "shape"))
        {
            text=son->FirstChild()->ToText();
            data.shape=text->Value();    
        }
    }
    return data;
}

map<string, string> ParseXML::getPublic()
{
    std::map<string, string> data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    const char* str;
    const char* str2;
    node=root->FirstChildElement();
    for(search=node->FirstChildElement();search!=NULL; search=search->NextSiblingElement()){
        TiXmlNode *tmp=search->FirstChild();
        if(tmp->Type()==TiXmlNode::TINYXML_TEXT){
            text=search->FirstChild()->ToText();
            str=search->Value();
            str2=text->Value();
            data.insert(make_pair(str, str2));
        }else
            continue;
    }
    return data;
}

CSNSsam ParseXML::getSample()
{
    CSNSsam data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    getNode(root,search, "NXsample");
    if(getNode(search, node, "chemical_formula"))
    {
        text=node->FirstChild()->ToText();
        data.chemical_formula=text->Value();
    }
    if(getNode(search,node, "name"))
    {
        text=node->FirstChild()->ToText();
        data.name=text->Value();
    }

    if(getNode(search,node, "situation"))
    {
        text=node->FirstChild()->ToText();
        data.situation=text->Value();
    }
    if(getNode(search,node, "type"))
    {
        text=node->FirstChild()->ToText();
        data.type=text->Value();
    }
    if(getNode(search, node, "density"))
    {
        text=node->FirstChild()->ToText();
        data.density=atof(text->Value());
    }
    if(getNode(search, node, "mass"))
    {
        text=node->FirstChild()->ToText();
        data.mass=atof(text->Value());
    }
    getDistance(search,data.distance);
    data.geometry=getGeometry(search); 
    return data;
}

vector<CSNSse> ParseXML::getSE()
{
    std::vector<CSNSse> data;
    CSNSse tmp;
    TiXmlElement *search, *search2, *node, *group;
    TiXmlText *text;
    TiXmlAttribute *attr;
    getNode(root, search, "NXenvironment");
    for(node=search->FirstChildElement();node!=NULL;node=node->NextSiblingElement())
    {
        if(0==strcmp("NXnote",node->Value()))
        {
            attr=node->FirstAttribute();
            tmp.seName=attr->Value();
            if(getNode(node, group, "name"))
            {
                text=group->FirstChild()->ToText();
                tmp.name=text->Value();
            }
            if(getNode(node, group, "type"))
            {
                text=group->FirstChild()->ToText();
                tmp.type=text->Value();
            }
            data.push_back(tmp);
        }        
    }
    return data;
}
vector<CSNSdc> ParseXML::getDC()
{
    std::vector<CSNSdc> data;
    CSNSdc tmp;
    TiXmlElement *search, *node, *group;
    TiXmlText *text;
    TiXmlAttribute *attr;
    getNode(root, search, "NXdisk_chopper");
    for(search; search!=NULL; search=search->NextSiblingElement())
    {
        if(0==strcmp("NXdisk_chopper", search->Value()))
        {
            attr=search->FirstAttribute();
            tmp.dcName=attr->Value();
            if(getNode(search, group, "phase"))
            {
                text=group->FirstChild()->ToText();
                tmp.phase=atof(text->Value());
            }
            if(getNode(search, group, "slit_angle"))
            {
                text=group->FirstChild()->ToText();
                tmp.slitAngle=atof(text->Value());
            }
            if(getNode(search, group, "rotation_speed"))
            {
                text=group->FirstChild()->ToText();
                tmp.rotationSpeed=atof(text->Value());
            }
            getDistance(search, tmp.distance);
            data.push_back(tmp);
        }
   }
    return data;
}
CSNSsource ParseXML::getSource()
{
    CSNSsource data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    getNode(root,search,"NXsource"); 

    if(getNode(search, node, "name"))
    {
        text=node->FirstChild()->ToText();
        data.name=text->Value();
    }
    if(getNode(search, node, "type"))
    {
        text=node->FirstChild()->ToText();
        data.type=text->Value();
    }
    if(getNode(search, node, "probe"))
    {
        text=node->FirstChild()->ToText();
        data.probe=text->Value();
    }
    if(getNode(search, node, "frequency"))
    {
        text=node->FirstChild()->ToText();
        data.frequency=atof(text->Value());
    }
    if(getNode(search, node, "power"))
    {
        text=node->FirstChild()->ToText();
        data.power=atof(text->Value());
    }
    return data;
}
CSNSmoderator ParseXML::getModerator()
{
    CSNSmoderator data;
    TiXmlElement *search, *node;
    TiXmlText *text;
    getNode(root, search, "NXmoderator"); 

    if(getNode(search, node, "type"))
    {
        text=node->FirstChild()->ToText();
        data.type=(text->Value());
    }
    if(getNode(search, node, "temperature"))
    {
        text=node->FirstChild()->ToText();
        data.temperature=atof(text->Value());
    }
    getDistance(search, data.distance);
    return data;
}
vector<CSNSaperture> ParseXML::getAperture()
{
    vector<CSNSaperture> data;
    CSNSaperture tmp;
    TiXmlElement *search, *node;
    TiXmlAttribute *attr;
    getNode(root,search, "NXaperture");
    for(search; search!=NULL; search=search->NextSiblingElement())
    {
        if(0==strcmp("NXaperture",search->Value()))
        {
            attr=search->FirstAttribute();
            tmp.apertureName=attr->Value();
        getDistance(search, tmp.distance);
        tmp.geometry=getGeometry(search);    
        data.push_back(tmp);
        }
    }
    return data;
}
CSNSbs ParseXML::getBS()
{
    CSNSbs data;
    TiXmlElement *search, *node;
    getNode(root, search, "NXbeam_stop");
    data.geometry=getGeometry(search);
    getDistance(search, data.distance);
    TiXmlText *text;
    getNode(search, node, "status");
    text=node->FirstChild()->ToText();
    data.status=text->Value();
    return data;
}

CSNSlogs ParseXML::getLogs()
{
    CSNSlogs data;
    TiXmlElement *search, *node, *group;
    TiXmlText *text;
    const char* str2;
    getNode(root, search, "NXcollection");

    getNode(search, node, "proton_charge");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.proton_charge,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search, node, "disk_chopper_phase1");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.disk_chopper_phase1,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search, node, "sample_electric_field");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_electric_field,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search,node, "sample_magnetic_field");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_magnetic_field,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search,node, "sample_pressure");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_pressure,str2,boost::is_any_of(":"), boost::token_compress_on);

    getNode(search, node, "sample_environment_temperature");
    text=node->FirstChild()->ToText();
    str2=text->Value();
    boost::split(data.sample_environment_temperature,str2,boost::is_any_of(":"), boost::token_compress_on);

    return data;
}
vector<string> ParseXML::getBankName()
{
    vector<string> data;
    string name;
    TiXmlElement *search, *node, *group;
    TiXmlAttribute *attr;
    getNode(root, search, "type", "name", "detector");
    for(node=search->FirstChildElement();node!=NULL;node=node->NextSiblingElement())
    {
        getNode(node,group,"location");
        for(attr=group->FirstAttribute();attr!=NULL;attr=attr->Next())
        {
            if(0==strcmp("name",attr->Name()))
                name=attr->Value();
        }
        data.push_back(name);
    }
    return data;
}

map<string, float> ParseXML::getBankInfo(const char* bankName)
{
    map<string, float> data;
    TiXmlElement *search, *psearch;
    TiXmlNode *node;
    TiXmlAttribute *attr;
    getNode(root, search, "location", "name", bankName);
    for(attr=search->FirstAttribute();attr!=NULL;attr=attr->Next())
    {
        if(0==strcmp("x",attr->Name())||
           0==strcmp("y",attr->Name())||
           0==strcmp("z",attr->Name()))
            data.insert(make_pair(attr->Name(),atof(attr->Value()))); 
    }
    node=search;
    node=node->Parent();
    psearch=node->ToElement();
    for(attr=psearch->FirstAttribute();attr!=NULL; attr=attr->Next())
    {
        if(0==strcmp("idstart",attr->Name())||
           0==strcmp("idstepbyrow",attr->Name()))
            data.insert(make_pair(attr->Name(),atof(attr->Value())));
    }
    getNode(psearch, search, "rot");
    for(attr=search->FirstAttribute();attr!=NULL; attr=attr->Next())
        data.insert(make_pair(attr->Name(),atof(attr->Value())));

    getNode(root, search, "type", "is", "rectangularDetector");
    for(attr=search->FirstAttribute();attr!=NULL; attr=attr->Next())
    {
        if(0==strcmp("xpixels",attr->Name())||
           0==strcmp("ypixels",attr->Name())||
           0==strcmp("xstart",attr->Name())||
           0==strcmp("ystart",attr->Name())||
           0==strcmp("xstep",attr->Name())||
           0==strcmp("ystep",attr->Name()))
            data.insert(make_pair(attr->Name(),atof(attr->Value())));
    }
    return data;
}
void ParseXML::setBankInfo(const char* bankName, float distance[], int64_t* pid, float* r, float* theta, float* phi)
{
    map<string, float> bankData=getBankInfo(bankName);
    //set distance
    distance[0]=bankData["x"];
    distance[1]=bankData["y"];
    distance[2]=bankData["z"];
    //set pixel_id
    int xpid=int(bankData["xpixels"]);
    int ypid=int(bankData["ypixels"]);
    cout<<"xpid: "<<xpid<<" "<<"ypid: "<<ypid<<endl;
    int n1=0;
    cout<<bankData["idstart"]<<" "<<bankData["idstepbyrow"]<<endl;
    for(int i=0; i<ypid; i++){
        for(int j=0; j<xpid; j++){
            pid[n1]=int(bankData["idstart"])+int(bankData["idstepbyrow"])*i+j;
            n1++;
        }
    }
    //set relative position
    float* xpos=new float[xpid*ypid];
    float* ypos=new float[xpid*ypid];
    float* zpos=new float[xpid*ypid];
    float* nxpos=new float[xpid*ypid];
    float* nypos=new float[xpid*ypid];
    float* nzpos=new float[xpid*ypid];
    n1=0;
    for(int i=0; i<ypid; i++){
        for(int j=0; j<xpid; j++){
            xpos[n1]=bankData["xstart"]+bankData["xstep"]*j;
            ypos[n1]=bankData["ystart"]+bankData["ystep"]*i;
            zpos[n1]=0.0;
            n1++;
        }
    }    
    //set absolute position
    //translate
    cout<<"x,y,z: "<<bankData["x"]<<", "<<bankData["y"]<<", "<<bankData["z"]<<endl;
    for(int num=0; num!=xpid*ypid; num++)
    {
        xpos[num]+=bankData["x"];
        ypos[num]+=bankData["y"];
        zpos[num]+=bankData["z"];
    }
    cout<<"translation: "<<xpos[0]<<" "<<ypos[0]<<" "<<zpos[0]<<endl; 
    //rot
    float theta2=bankData["val"];
    if(theta2>0){
        theta2=(theta2)/180.0*M_PI;
    }else{
        theta2=(360+theta2)/180.0*M_PI;
    }

    if(bankData["axis-y"]==1.0)
    {
        cout<<"theta: "<<theta2<<" "<<cos(theta2)<<endl;
        for(int num=0; num!=xpid*ypid; num++)
        {
            nzpos[num]=(zpos[num]-bankData["z"])*cos(theta2)-(xpos[num]-bankData["x"])*sin(theta2)+bankData["z"];
            nxpos[num]=(zpos[num]-bankData["z"])*sin(theta2)+(xpos[num]-bankData["x"])*cos(theta2)+bankData["x"];
            nypos[num]=ypos[num];
        }
    }else if(bankData["axis-x"]==1.0)
    {
        for(int num=0; num!=xpid*ypid; num++)
        {
            nzpos[num]=(ypos[num]-bankData["y"])*cos(theta2)-(zpos[num]-bankData["z"])*sin(theta2)+bankData["y"];
            nxpos[num]=(ypos[num]-bankData["y"])*sin(theta2)+(zpos[num]-bankData["z"])*cos(theta2)+bankData["z"];
            nxpos[num]=xpos[num];
        }
    }else{
        for(int num=0; num!=xpid*ypid; num++)
        {
            nxpos[num]=(xpos[num]-bankData["x"])*cos(theta2)-(ypos[num]-bankData["y"])*sin(theta2)+bankData["x"];
            nypos[num]=(xpos[num]-bankData["x"])*sin(theta2)+(ypos[num]-bankData["y"])*cos(theta2)+bankData["y"];
            nzpos[num]=zpos[num];
        }
    }
    //set (r, theta, phi)
    for(int num=0;num!=xpid*ypid; num++)
    {
        r[num]=sqrt(nxpos[num]*nxpos[num]+nypos[num]*nypos[num]+nzpos[num]*nzpos[num]);
        theta[num]=180/M_PI*acos(nzpos[num]/r[num]);
        phi[num]=180/M_PI*atan(nypos[num]/nxpos[num]);//wrong =pi-phi
    }
    
}
