/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.User;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.UserFacade;
import java.io.Serializable;
import java.security.Principal;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.inject.Named;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class LoginController implements Serializable {

    private String initialUri;
    private String initialQueryString;
    private String userName;
    private String credentials;
    private User user;

    @EJB
    private UserFacade facade;

    /**
     * Creates a new instance of LoginController
     */
    public LoginController() {
    }

    @PostConstruct
    private void init() {
        FacesContext context = FacesContext.getCurrentInstance();
        initialUri = (String) context.getExternalContext().getRequestMap()
                .get(RequestDispatcher.FORWARD_REQUEST_URI);
        initialQueryString = (String) context.getExternalContext().getRequestMap()
                .get(RequestDispatcher.FORWARD_QUERY_STRING);
    }

    public String login() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest) context.getExternalContext().getRequest();
        try {
            Principal userPrincipal = request.getUserPrincipal();
            if (null != userPrincipal) {
                return "/public/login?faces-redirect=true";
            }

            request.login(userName, credentials);

            String loggedUser = request.getRemoteUser();
            if (!isUserExist(loggedUser)) {
                try {
                    addUser(loggedUser);
                } catch (IpsException ex) {
                    Logger.getLogger(LoginController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    FacesContext.getCurrentInstance().getExternalContext().invalidateSession();
                    FacesContext.getCurrentInstance()
                            .addMessage(null,
                                    new FacesMessage(FacesMessage.SEVERITY_FATAL,
                                            "Server internal error.", "Cannot add new user."));
                    return null;
                }
            }

            if (null != initialUri && !initialUri.equals("")) {
                String initialUrl = initialUri.substring(initialUri.indexOf('/', 1));
                if (initialUrl.trim().equals("") || initialUrl.trim().equals("/")) {
                    initialUrl = "/index?faces-redirect=true";
                } else {
                    initialUrl = initialUrl + "?faces-redirect=true" + (null == initialQueryString ? "" : "&" + initialQueryString);
                }

                //context.getExternalContext().redirect(initialUri + "?" + initialQueryString);
                return initialUrl;
            } else {
                return "/index?faces-redirect=true";
            }

        } catch (ServletException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    private boolean isUserExist(String username) {
        User found;
        try {
            found = facade.findByName(username);
            if (null == found) {
                return false;
            }
        } catch (IpsException ex) {
            Logger.getLogger(LoginController.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    private void addUser(String username) throws IpsException {
        user = new User();
        Date now = new Date();
        user.setCreateId(username);
        user.setCreateTime(now);
        user.setModId(username);
        user.setModTime(now);
        user.setName(username);
        facade.create(user);
        //facade.flush();
        String message = "New user added successfully: User[" + user.getId() + ", " + user.getName() + "].";
        Logger.getLogger(LoginController.class.getName()).log(Level.INFO, message);

        user = null;
    }

    /**
     * Logout and invalidate all session data.
     *
     * @return success
     */
    public String logout() {
        FacesContext.getCurrentInstance().getExternalContext().invalidateSession();
        return "success";
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCredentials() {
        return credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

}
