/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.UserGroup;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.UserGroupFacade;
import cn.ac.csns.portal.proposalsystem.util.PermissionChecker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.transaction.Transactional;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class UserGroupController implements Serializable {

    private UserGroup current;
    private String currentUser;
    private List<UserGroup> userGroups;

    @EJB
    private UserGroupFacade facade;

    /**
     * Creates a new instance of FacilityController
     */
    public UserGroupController() {
        current = new UserGroup();
    }

    @PostConstruct
    private void init() {
        currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
    }

    @Transactional
    public void add() {
        Date now = new Date();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        String message;
        try {
            facade.create(current);
            facade.flush();
            message = "User added to group successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(UserGroupController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add user to group.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        current = new UserGroup();
    }

    public void remove(UserGroup userGroup) {
        String message;
        try {
            facade.remove(userGroup);
            message = "User removed from group.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove user from group: "
                    + userGroup.getUser().getName() + " - "
                    + userGroup.getGroup().getName();
            Logger.getLogger(UserGroupController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public UserGroup getCurrent() {
        return current;
    }

    public void setCurrent(UserGroup current) {
        this.current = current;
    }

    public List<UserGroup> getUserGroups() {
        try {
            if (PermissionChecker.isAdministrator(FacesContext.getCurrentInstance())) {
                userGroups = facade.findAll();
            } else {
                List<UserGroup> temp = new ArrayList<>();
                temp.addAll(facade.findByUserName(currentUser));
                temp.addAll(facade.findByCreator(currentUser));
                userGroups = temp.stream().distinct().collect(Collectors.toList());
            }
        } catch (IpsException ex) {
            Logger.getLogger(UserGroupController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            String message = "Error occurred when retriving user groups";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
            return null;
        }
        return userGroups;
    }

}
