/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.SampleType;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.SampleTypeFacade;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class SampleTypeController implements Serializable {

    private SampleType current;

    @Inject
    private AppDataController appData;

    @EJB
    private SampleTypeFacade facade;

    /**
     * Creates a new instance of FacilityController
     */
    public SampleTypeController() {
        current = new SampleType();
    }

    @Transactional
    public void add() {
        Date now = new Date();
        String currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        String message;
        try {
            facade.create(current);
            facade.flush();
            appData.freshSampleTypes();
            message = "Sample type added successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(SampleTypeController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add sample type.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        current = new SampleType();
    }

    public void remove(SampleType investigationType) {
        String message;
        try {
            facade.remove(investigationType);
            appData.freshSampleTypes();
            message = "Sample type removed: " + investigationType.getName();
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove sample type: " + investigationType.getName();
            Logger.getLogger(SampleTypeController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public SampleType getCurrent() {
        return current;
    }

    public void setCurrent(SampleType current) {
        this.current = current;
    }

}
