/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Facility;
import cn.ac.csns.portal.proposalsystem.entity.Instrument;
import cn.ac.csns.portal.proposalsystem.entity.InstrumentScientist;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.InstrumentScientistFacade;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class InstrumentScientistController implements Serializable {

    private InstrumentScientist current;
    private Facility facility;
    private final List<Instrument> filteredInstruments;

    @Inject
    private AppDataController appData;

    @EJB
    private InstrumentScientistFacade facade;

    /**
     * Creates a new instance of FacilityController
     */
    public InstrumentScientistController() {
        current = new InstrumentScientist();
        filteredInstruments = new ArrayList<>();
    }

    @Transactional
    public void add() {
        Date now = new Date();
        String currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        String message;
        try {
            facade.create(current);
            facade.flush();
            appData.freshInstrumentScientists();
            message = "Instrument scientist added successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(InstrumentScientistController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add instrument scientist.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        current = new InstrumentScientist();
    }

    public void remove(InstrumentScientist instrumentScientist) {
        String message;
        try {
            facade.remove(instrumentScientist);
            appData.freshInstrumentScientists();
            message = "Instrument scientist removed: " + instrumentScientist.toString();
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove instrument scientist: " + instrumentScientist.toString();
            Logger.getLogger(InstrumentScientistController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public void filterInstrumentByFacility() {
        filteredInstruments.clear();
        if (null != facility) {
            appData.getInstruments().stream().filter((instrument) -> (instrument.getFacility().equals(facility))).forEach((instrument) -> {
                filteredInstruments.add(instrument);
            });
        }
    }

    public InstrumentScientist getCurrent() {
        return current;
    }

    public void setCurrent(InstrumentScientist current) {
        this.current = current;
    }

    public Facility getFacility() {
        return facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public List<Instrument> getFilteredInstruments() {
        return filteredInstruments;
    }

}
