/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Instrument;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.InstrumentFacade;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class InstrumentController implements Serializable {

    private Instrument current;

    @Inject
    private AppDataController appData;

    @EJB
    private InstrumentFacade facade;

    /**
     * Creates a new instance of FacilityController
     */
    public InstrumentController() {
        current = new Instrument();
    }

    @Transactional
    public void add() {
        Date now = new Date();
        String currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        String message;
        try {
            facade.create(current);
            facade.flush();
            appData.freshInstruments();
            message = "Instrument added successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(InstrumentController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add instrument.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        current = new Instrument();
    }

    public void remove(Instrument instrument) {
        String message;
        try {
            facade.remove(instrument);
            appData.freshInstruments();
            appData.freshInstrumentScientists();
            message = "Instrument removed: " + instrument.getName();
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove instrument: " + instrument.getName();
            Logger.getLogger(InstrumentController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public Instrument getCurrent() {
        return current;
    }

    public void setCurrent(Instrument current) {
        this.current = current;
    }

}
