/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Grouping;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.GroupingFacade;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.transaction.Transactional;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class GroupingController implements Serializable {

    private Grouping current;
    private List<Grouping> groups;

    @EJB
    private GroupingFacade facade;

    /**
     * Creates a new instance of GroupingController
     */
    public GroupingController() {
        current = new Grouping();
    }

    @Transactional
    public void add() {
        Date now = new Date();
        String currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        String message;
        try {
            facade.create(current);
            facade.flush();
            message = "Group added successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(GroupingController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add group.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        current = new Grouping();
    }

    public void remove(Grouping grouping) {
        String message;
        try {
            facade.remove(grouping);
            message = "Group removed: " + grouping.getName();
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove group: " + grouping.getName();
            Logger.getLogger(GroupingController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public Grouping getCurrent() {
        return current;
    }

    public void setCurrent(Grouping current) {
        this.current = current;
    }

    public List<Grouping> getGroups() {
        try {
            groups = facade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(UserController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            String message = "Error occurred when retrive groups.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
            return null;
        }
        return groups;
    }

}
