/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.converter;

import cn.ac.csns.portal.proposalsystem.entity.EntityBase;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.AbstractFacade;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
public abstract class AbstractEntityConverter<T extends EntityBase> implements Converter {

    private final Class<T> entityClass;
    private AbstractFacade entityFacade;

    public AbstractEntityConverter(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    protected Converter getConverter(AbstractFacade entityFacade) {
        this.entityFacade = entityFacade;
        return this;
    }

    public abstract Converter getConverter();

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (value == null) {
            return null;
        }
        if (value.trim().isEmpty()) {
            return null;
        }

        try {
            return entityFacade.find(Long.parseLong(value));
        } catch (IpsException ex) {
            Logger.getLogger(AbstractEntityConverter.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL,
                            ex.getLocalizedMessage(),
                            ex.getLocalizedMessage()));
            return null;
        }

    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        if (!entityClass.isInstance(value)) {
            return null;
        }

        return String.valueOf(((T) value).getId());
    }

}
