/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Facility;
import cn.ac.csns.portal.proposalsystem.entity.FacilityCycle;
import cn.ac.csns.portal.proposalsystem.entity.Grouping;
import cn.ac.csns.portal.proposalsystem.entity.Instrument;
import cn.ac.csns.portal.proposalsystem.entity.Investigation;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationGroup;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationInstrument;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationStatus;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationType;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationUser;
import cn.ac.csns.portal.proposalsystem.entity.Keyword;
import cn.ac.csns.portal.proposalsystem.entity.Sample;
import cn.ac.csns.portal.proposalsystem.entity.SampleType;
import cn.ac.csns.portal.proposalsystem.entity.Study;
import cn.ac.csns.portal.proposalsystem.entity.StudyInvestigation;
import cn.ac.csns.portal.proposalsystem.entity.User;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.InvestigationFacade;
import cn.ac.csns.portal.proposalsystem.facade.UserFacade;
import cn.ac.csns.portal.proposalsystem.util.EntityCreateTimeComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.flow.FlowScoped;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.primefaces.event.SelectEvent;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@FlowScoped("createproposal")
public class CreateProposalController implements Serializable {

    private static final String KEYWORDS_SEPARATOR = ",";

    private String keywordsStr;
    private String user;
    private Investigation newInvestigation;
    private List<Sample> samples;
    private Facility facility;
    private List<FacilityCycle> filteredFacilityCycles;
    private List<InvestigationType> filteredInvestigationTypes;
    private List<Instrument> filteredInstruments;
    private List<SampleType> filteredSampleTypes;
    private Instrument preferredInstrument;
    private List<Study> studies;
    private Study selectedStudy;
    private User selectedUser;
    private Grouping selectedGroup;
    private List<Grouping> groupMembers;
    private List<User> userMembers;
    private boolean primaryGroup = false;
    private final Map<Long, String> groupRoles;

    @Inject
    private AppDataController appData;
    @EJB
    private InvestigationFacade facade;
    @EJB
    private UserFacade userFacade;
    @Inject
    private Validator validator;

    /**
     * Creates a new instance of CreateProposalController
     */
    public CreateProposalController() {
        newInvestigation = new Investigation();
        samples = new ArrayList<>();
        studies = new ArrayList<>();
        groupMembers = new ArrayList<>();
        userMembers = new ArrayList<>();
        groupRoles = new HashMap<>();
    }

    @PostConstruct
    private void init() {
        user = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        if (!appData.getFacilities().isEmpty()) {
            facility = appData.getFacilities().get(0);
            doFilter();
        }
        Date current = new Date();
        newInvestigation.setCreateId(user);
        newInvestigation.setCreateTime(current);
        newInvestigation.setModId(user);
        newInvestigation.setModTime(current);
        newInvestigation.setStatus(InvestigationStatus.NEW);
        try {
            userMembers.add(userFacade.findByName(user));
        } catch (IpsException ex) {
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public void onSampleAdd(SelectEvent event) {
        if (null == event.getObject() || !(event.getObject() instanceof Sample)) {
            return;
        }
        Sample newSample = (Sample) event.getObject();
        samples.add(newSample);
    }

    public void doFilter() {
        filteredFacilityCycles = filterFacilityCycles(facility);
        filteredInvestigationTypes = filterInvestigationTypes(facility);
        filteredInstruments = filterInstruments(facility);
        filteredSampleTypes = filterSampleType(facility);
    }

    public void addStudy() {
        if (selectedStudy == null) {
            return;
        }
        if (studies.contains(selectedStudy)) {
            return;
        }
        studies.add(selectedStudy);
    }

    public void removeStudy(Study study) {
        try {
            studies.remove(study);
        } catch (Exception ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public String resetStudies() {
        studies = new ArrayList<>();
        saveStudy();
        return "";
    }

    public void addGroup() {
        if (selectedGroup == null) {
            return;
        }
        if (groupMembers.contains(selectedGroup)) {
            return;
        }
        if (primaryGroup) {
            groupRoles.put(selectedGroup.getId(), "Primary");
        } else {
            groupRoles.put(selectedGroup.getId(), "Common");
        }
        groupMembers.add(selectedGroup);
        primaryGroup = false;
    }

    public void removeGroup(Grouping group) {
        try {
            groupMembers.remove(group);
            groupRoles.remove(group.getId());
        } catch (Exception ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    private void saveGroupMembers() {
        List<InvestigationGroup> investigationGroups = new ArrayList<>();
        Date current = new Date();
        groupMembers.stream().forEach(gm -> {
            InvestigationGroup investigationGroup = new InvestigationGroup();
            investigationGroup.setCreateId(user);
            investigationGroup.setCreateTime(current);
            investigationGroup.setModId(user);
            investigationGroup.setModTime(current);
            investigationGroup.setGroupRole(groupRoles.get(gm.getId()));
            investigationGroup.setInvestigation(newInvestigation);
            investigationGroup.setGroup(gm);
            investigationGroups.add(investigationGroup);
        });
        newInvestigation.setInvestigationGroups(investigationGroups);
        FacesContext.getCurrentInstance()
                .addMessage(null,
                        new FacesMessage(FacesMessage.SEVERITY_INFO,
                                "Group members saved", "Group members saved"));
    }

    public void addUser() {
        if (selectedUser == null) {
            return;
        }
        if (userMembers.contains(selectedUser)) {
            return;
        }
        userMembers.add(selectedUser);
    }

    public void removeUser(User user) {
        try {
            userMembers.remove(user);
        } catch (Exception ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    private void saveUserMembers() {
        List<InvestigationUser> investigationUsers = new ArrayList<>();
        Date current = new Date();
        userMembers.stream().forEach((u) -> {
            InvestigationUser investigationUser = new InvestigationUser();
            investigationUser.setCreateId(user);
            investigationUser.setCreateTime(current);
            investigationUser.setModId(user);
            investigationUser.setModTime(current);
            investigationUser.setUserRole("Participator");
            if (u.getName().equals(user)) {
                investigationUser.setUserRole("Primary");
            }
            investigationUser.setInvestigation(newInvestigation);
            investigationUser.setUser(u);
            investigationUsers.add(investigationUser);
        });
        newInvestigation.setInvestigationUsers(investigationUsers);
        FacesContext.getCurrentInstance()
                .addMessage(null,
                        new FacesMessage(FacesMessage.SEVERITY_INFO,
                                "User members saved", "User members saved"));
    }

    public String resetMembers() {
        groupMembers = new ArrayList<>();
        saveGroupMembers();
        userMembers = new ArrayList<>();
        saveUserMembers();
        return "";
    }

    private List<FacilityCycle> filterFacilityCycles(Facility selectedFacility) {
        List<FacilityCycle> filteredFCs = new ArrayList<>();
        appData.getFacilityCycles().stream()
                .filter((fc) -> (fc.getFacility().equals(selectedFacility)))
                .sorted(new EntityCreateTimeComparator<>(true))
                .forEach((fc) -> {
                    filteredFCs.add(fc);
                });
        return filteredFCs;
    }

    private List<InvestigationType> filterInvestigationTypes(Facility selectedFacility) {
        List<InvestigationType> filteredITs = new ArrayList<>();
        appData.getInvestigationTypes().stream()
                .filter((it) -> (it.getFacility().equals(selectedFacility)))
                .forEach((it) -> {
                    filteredITs.add(it);
                });
        return filteredITs;
    }

    private List<Instrument> filterInstruments(Facility selectedFacility) {
        return appData.getInstruments().stream()
                .filter(ins -> ins.getFacility().equals(selectedFacility))
                .collect(Collectors.toList());
    }

    private List<SampleType> filterSampleType(Facility selectedFacility) {
        return appData.getSampleTypes().stream()
                .filter(st -> st.getFacility().equals(selectedFacility))
                .sorted((SampleType o1, SampleType o2)
                        -> o1.getName().compareToIgnoreCase(o2.getName()))
                .collect(Collectors.toList());
    }

    public void removeSample(Sample sample) {
        try {
            samples.remove(sample);
        } catch (Exception ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public String resetSamples() {
        samples = new ArrayList<>();
        saveSample();
        return "";
    }

    private List<String> processKeywordsStr() {
        return Arrays.<String>asList(keywordsStr.split(KEYWORDS_SEPARATOR))
                .stream().map(String::trim)
                .filter(item -> !item.isEmpty())
                .distinct().collect(Collectors.toList());
    }

    private List<Keyword> createInvetigationKeywords(List<String> keywordsList) {
        List<Keyword> keywords = new ArrayList<>();
        Date current = new Date();
        keywordsList.stream().forEach(item -> {
            Keyword keyword = new Keyword();
            keyword.setCreateId(user);
            keyword.setCreateTime(current);
            keyword.setModId(user);
            keyword.setModTime(current);
            keyword.setName(item);
            keyword.setInvestigation(newInvestigation);
            keywords.add(keyword);
        });
        return keywords;
    }

    public String saveBasic() {
        List<String> keywordsList = processKeywordsStr();
        List<Keyword> keywords = createInvetigationKeywords(keywordsList);
        newInvestigation.setFacility(facility);
        newInvestigation.setKeywords(keywords);
        FacesContext.getCurrentInstance().addMessage(null,
                new FacesMessage(FacesMessage.SEVERITY_INFO,
                        "Save successfully",
                        "Save successfully"));
        return "";
    }

    public String saveInstrument() {
        List<InvestigationInstrument> investigationInstruments = new ArrayList<>();
        Date current = new Date();
        InvestigationInstrument investigationInstrument = new InvestigationInstrument();
        investigationInstrument.setCreateId(user);
        investigationInstrument.setCreateTime(current);
        investigationInstrument.setModId(user);
        investigationInstrument.setModTime(current);
        investigationInstrument.setInstrument(preferredInstrument);
        investigationInstrument.setInvestigation(newInvestigation);
        investigationInstruments.add(investigationInstrument);
        newInvestigation.setInvestigationInstruments(investigationInstruments);
        FacesContext.getCurrentInstance().addMessage(null,
                new FacesMessage(FacesMessage.SEVERITY_INFO,
                        "Save successfully",
                        "Save successfully"));
        return "";
    }

    public String saveSample() {
        samples.stream().forEach((s) -> {
            s.setInvestigation(newInvestigation);
        });
        newInvestigation.setSamples(samples);
        FacesContext.getCurrentInstance().addMessage(null,
                new FacesMessage(FacesMessage.SEVERITY_INFO,
                        "Save successfully",
                        "Save successfully"));
        return "";
    }

    public String saveStudy() {
        List<StudyInvestigation> studyInvestigations = new ArrayList<>();
        Date current = new Date();
        studies.stream().forEach((s) -> {
            StudyInvestigation studyInvestigation = new StudyInvestigation();
            studyInvestigation.setCreateId(user);
            studyInvestigation.setCreateTime(current);
            studyInvestigation.setModId(user);
            studyInvestigation.setModTime(current);
            studyInvestigation.setInvestigation(newInvestigation);
            studyInvestigation.setStudy(s);
            studyInvestigations.add(studyInvestigation);
        });
        newInvestigation.setStudyInvestigations(studyInvestigations);
        FacesContext.getCurrentInstance()
                .addMessage(null,
                        new FacesMessage(FacesMessage.SEVERITY_INFO,
                                "Studies Saved", "Studies Saved"));
        return "";
    }

    public String saveMember() {
        saveGroupMembers();
        saveUserMembers();
        FacesContext.getCurrentInstance()
                .addMessage(null,
                        new FacesMessage(FacesMessage.SEVERITY_INFO,
                                "All members saved", "All members saved"));
        return "";
    }

    public String save() {
        try {
            Set<ConstraintViolation<Investigation>> constrainViolations = validator.validate(newInvestigation);
            if (!constrainViolations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                constrainViolations.stream().forEach(cv -> {
                    sb.append(cv.getPropertyPath().toString());
                    sb.append(" ");
                    sb.append(cv.getMessage());
                    sb.append("; ");
                });
                FacesContext.getCurrentInstance()
                        .addMessage(null,
                                new FacesMessage(FacesMessage.SEVERITY_FATAL, sb.toString(), sb.toString()));
                return "";
            }
            facade.create(newInvestigation);
            return "/index";
        } catch (IpsException ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
            return "";
        }
    }

    public String cancle() {
        return "/index";
    }

    public Investigation getNewInvestigation() {
        return newInvestigation;
    }

    public void setNewInvestigation(Investigation newInvestigation) {
        this.newInvestigation = newInvestigation;
    }

    public String getKeywordsStr() {
        return keywordsStr;
    }

    public void setKeywordsStr(String keywordsStr) {
        this.keywordsStr = keywordsStr;
    }

    public List<Sample> getSamples() {
        return samples;
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    public Facility getFacility() {
        return facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public List<FacilityCycle> getFilteredFacilityCycles() {
        return filteredFacilityCycles;
    }

    public List<InvestigationType> getFilteredInvestigationTypes() {
        return filteredInvestigationTypes;
    }

    public List<Instrument> getFilteredInstruments() {
        return filteredInstruments;
    }

    public Instrument getPreferredInstrument() {
        return preferredInstrument;
    }

    public List<SampleType> getFilteredSampleTypes() {
        return filteredSampleTypes;
    }

    public void setPreferredInstrument(Instrument preferredInstrument) {
        this.preferredInstrument = preferredInstrument;
    }

    public List<Study> getStudies() {
        return studies;
    }

    public Study getSelectedStudy() {
        return selectedStudy;
    }

    public void setSelectedStudy(Study selectedStudy) {
        this.selectedStudy = selectedStudy;
    }

    public User getSelectedUser() {
        return selectedUser;
    }

    public void setSelectedUser(User selectedUser) {
        this.selectedUser = selectedUser;
    }

    public Grouping getSelectedGroup() {
        return selectedGroup;
    }

    public void setSelectedGroup(Grouping selectedGroup) {
        this.selectedGroup = selectedGroup;
    }

    public List<Grouping> getGroupMembers() {
        return groupMembers;
    }

    public List<User> getUserMembers() {
        return userMembers;
    }

    public boolean isPrimaryGroup() {
        return primaryGroup;
    }

    public void setPrimaryGroup(boolean primaryGroup) {
        this.primaryGroup = primaryGroup;
    }

    public Map<Long, String> getGroupRoles() {
        return groupRoles;
    }

}
