/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Facility;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.FacilityFacade;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ApplicationScoped
public class AppDataController {

    private List<Facility> facilities;

    @EJB
    private FacilityFacade facilityFacade;

    /**
     * Creates a new instance of AppDataController
     */
    public AppDataController() {
    }

    @PostConstruct
    private void init() {
        try {
            facilities = facilityFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public void freshFacilities() {
        try {
            facilities = facilityFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public List<Facility> getFacilities() {
        return facilities;
    }

    public void setFacilities(List<Facility> facilities) {
        this.facilities = facilities;
    }

}
