/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * Many to many relationship between study and investigation.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"STUDY_ID", "INVESTIGATION_ID"})})
public class StudyInvestigation extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    @JoinColumn(name = "STUDY_ID", nullable = false)
    @ManyToOne
    private Study study;

    @JoinColumn(name = "INVESTIGATION_ID", nullable = false)
    @ManyToOne
    private Investigation investigation;

    public StudyInvestigation() {
    }

    public Study getStudy() {
        return study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    public Investigation getInvestigation() {
        return investigation;
    }

    public void setInvestigation(Investigation investigation) {
        this.investigation = investigation;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof StudyInvestigation)) {
            return false;
        }
        StudyInvestigation other = (StudyInvestigation) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + " ]";
    }

}
