/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * A study which may be related to several investigations.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"NAME"})})
@NamedQueries({
    @NamedQuery(name = "Study.findByName",
            query = "SELECT s FROM Study s WHERE s.name = :name"),
    @NamedQuery(name = "Study.findByUser",
            query = "SELECT s FROM Study s WHERE s.user = :user")})
public class Study extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_NAME = "Study.findByName";
    public static final String FIND_BY_USER = "Study.findByUser";

    /**
     * The name of the study.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * A description of the study.
     */
    @Size(max = 4000)
    @Column(length = 4000)
    private String description;

    /**
     * The start date of this study.
     */
    @Temporal(TemporalType.TIMESTAMP)
    private Date startDate;

    /**
     * The status of the study.
     */
    @Basic(optional = false)
    @NotNull
    @Enumerated(EnumType.STRING)
    @Column(nullable = false, length = 12)
    private StudyStatus status;

    /**
     * The user responsible for the study.
     */
    @ManyToOne
    private User user;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "study")
    private List<StudyInvestigation> studyInvestigations;

    public Study() {
        studyInvestigations = new ArrayList<>();
    }

    /**
     * Get the value of studyInvestigations
     *
     * @return the value of studyInvestigations
     */
    public List<StudyInvestigation> getStudyInvestigations() {
        return studyInvestigations;
    }

    /**
     * Set the value of studyInvestigations
     *
     * @param studyInvestigations new value of studyInvestigations
     */
    public void setStudyInvestigations(List<StudyInvestigation> studyInvestigations) {
        this.studyInvestigations = studyInvestigations;
    }

    /**
     * Get the value of status
     *
     * @return the value of status
     */
    public StudyStatus getStatus() {
        return status;
    }

    /**
     * Set the value of status
     *
     * @param status new value of status
     */
    public void setStatus(StudyStatus status) {
        this.status = status;
    }

    /**
     * Get the value of description
     *
     * @return the value of description
     */
    public String getDescription() {
        return description;
    }

    /**
     * Set the value of description
     *
     * @param description new value of description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Get the value of name
     *
     * @return the value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the value of name
     *
     * @param name new value of name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Get the value of user
     *
     * @return the value of user
     */
    public User getUser() {
        return user;
    }

    /**
     * Set the value of user
     *
     * @param user new value of user
     */
    public void setUser(User user) {
        this.user = user;
    }

    /**
     * Get the value of startDate
     *
     * @return the value of startDate
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * Set the value of startDate
     *
     * @param startDate new value of startDate
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Study)) {
            return false;
        }
        Study other = (Study) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
