/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * A sample to be used in an investigation.
 *
 * @author tangm
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"INVESTIGATION_ID", "NAME"})})
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Sample.findByName",
            query = "SELECT s FROM Sample s WHERE s.name = :name"),
    @NamedQuery(name = "Sample.findByInvestigation",
            query = "SELECT s FROM Sample s WHERE s.investigation = :investigation")})
public class Sample extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_NAME = "Sample.findByName";
    public static final String FIND_BY_INVESTIGATION = "Sample.findByInvestigation";

    /**
     * The name of the sample.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * The summary description to the sample.
     */
    @Size(max = 2000)
    @Column(length = 2000)
    private String description;

    /**
     * The unit.
     */
    @Size(max = 255)
    @Column
    private String unit;

    /**
     * The mass.
     */
    @Column
    private Double mass;

    /**
     * The density.
     */
    @Column
    private Double density;

    /**
     * The quantity of sample.
     */
    @Basic(optional = false)
    @NotNull
    @Column(nullable = false)
    private Integer quantity;

    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column
    private String physicalState;

    @Size(max = 4000)
    @Column(length = 4000)
    private String environment;

    /**
     * The investigation which this sample related to.
     */
    @JoinColumn(name = "INVESTIGATION_ID", nullable = false)
    @ManyToOne(optional = false)
    private Investigation investigation;

    /**
     * The type of this sample.
     */
    @JoinColumn(name = "SAMPLETYPE_ID")
    @ManyToOne
    private SampleType type;

    public Sample() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Double getMass() {
        return mass;
    }

    public void setMass(Double mass) {
        this.mass = mass;
    }

    public Double getDensity() {
        return density;
    }

    public void setDensity(Double density) {
        this.density = density;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public String getPhysicalState() {
        return physicalState;
    }

    public void setPhysicalState(String physicalState) {
        this.physicalState = physicalState;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Investigation getInvestigation() {
        return investigation;
    }

    public SampleType getType() {
        return type;
    }

    public void setType(SampleType type) {
        this.type = type;
    }

    public void setInvestigation(Investigation investigation) {
        this.investigation = investigation;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Sample)) {
            return false;
        }
        Sample other = (Sample) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
