/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * A type of investigation.
 *
 * @author tangm
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"NAME", "FACILITY_ID"})})
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "InvestigationType.findByName",
            query = "SELECT t FROM InvestigationType t WHERE t.name = :name")})
public class InvestigationType extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;
    
    public static final String FIND_BY_NAME = "InvestigationType.findByName";

    /**
     * A short name identifying this type of investigation.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * A description of this type of investigation.
     */
    @Size(max = 255)
    @Column
    private String description;

    /**
     * A text will be shown in the UI.
     */
    @Size(max = 255)
    @Column
    private String display;

    /**
     * The facility which has defined this investigation type.
     */
    @JoinColumn(name = "FACILITY_ID", nullable = false)
    @ManyToOne
    private Facility facility;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "type")
    private List<Investigation> investigations;

    public InvestigationType() {
        investigations = new ArrayList<>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplay() {
        return display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Facility getFacility() {
        return facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    @XmlTransient
    public List<Investigation> getInvestigations() {
        return investigations;
    }

    public void setInvestigations(List<Investigation> investigations) {
        this.investigations = investigations;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof InvestigationType)) {
            return false;
        }
        InvestigationType other = (InvestigationType) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
