/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Instrument entity.
 *
 * @author tangm
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"FACILITY_ID", "NAME"})})
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Instrument.findByName", query = "SELECT i FROM Instrument i WHERE i.name = :name"),
    @NamedQuery(name = "Instrument.findByFullname", query = "SELECT i FROM Instrument i WHERE i.fullName = :fullname"),
    @NamedQuery(name = "Instrument.findByFacility", query = "SELECT i FROM Instrument i WHERE i.facility = :facility"),
    @NamedQuery(name = "Instrument.findByType", query = "SELECT i FROM Instrument i WHERE i.type = :type")})
public class Instrument extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_NAME = "Instrument.findByName";
    public static final String FIND_BY_FULL_NAME = "Instrument.findByFullname";
    public static final String FIND_BY_FACILITY = "Instrument.findByFacility";
    public static final String FIND_BY_TYPE = "Instrument.findByType";

    /**
     * A short name identifying this instrument within the facility.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * The formal name of this instrument.
     */
    @Size(max = 255)
    @Column
    private String fullName;

    /**
     * A description of this instrument.
     */
    @Size(max = 4000)
    @Column(length = 4000)
    private String description;

    /**
     * A URL associated with this instrument.
     */
    @Size(max = 255)
    @Column
    private String url;

    /**
     * The type of this instrument.
     */
    @Size(max = 255)
    @Column
    private String type;

    /**
     * The facility which has this instrument.
     */
    @JoinColumn(name = "FACILITY_ID", referencedColumnName = "ID", nullable = false)
    @ManyToOne(optional = false)
    private Facility facility;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "instrument")
    private List<InstrumentScientist> instrumentScientists;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "instrument")
    private List<InvestigationInstrument> investigationInstruments;

    public Instrument() {
        instrumentScientists = new ArrayList<>();
        investigationInstruments = new ArrayList<>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Facility getFacility() {
        return facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public List<InstrumentScientist> getInstrumentScientists() {
        return instrumentScientists;
    }

    public void setInstrumentScientists(List<InstrumentScientist> instrumentScientists) {
        this.instrumentScientists = instrumentScientists;
    }

    public List<InvestigationInstrument> getInvestigationInstruments() {
        return investigationInstruments;
    }

    public void setInvestigationInstruments(List<InvestigationInstrument> investigationInstruments) {
        this.investigationInstruments = investigationInstruments;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Instrument)) {
            return false;
        }
        Instrument other = (Instrument) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
