/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * An experimental facility.
 *
 * @author tangm
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"NAME"})})
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Facility.findByName", query = "SELECT f FROM Facility f WHERE f.name = :name"),
    @NamedQuery(name = "Facility.findByFullName", query = "SELECT f FROM Facility f WHERE f.fullName = :fullname")})
public class Facility extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_NAME = "Facility.findByName";
    public static final String FIND_BY_FULL_NAME = "Facility.findByFullName";

    /**
     * A short name identifying this facility.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * The full name of the facility.
     */
    @Size(max = 255)
    @Column
    private String fullName;

    /**
     * A description of this facility.
     */
    @Size(max = 1023)
    @Column(length = 1023)
    private String description;

    /**
     * A URL associated with this facility.
     */
    @Size(max = 255)
    @Column
    private String url;

    /**
     * The number of days before data is made freely available after collecting.
     */
    private Integer daysUntilRelease;

    /**
     * Cycles belong to this facility.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "facility")
    private List<FacilityCycle> facilityCycles;

    /**
     * Investigations belong to this facility.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "facility")
    private List<Investigation> investigations;

    /**
     * Investigation types this facility supports.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "facility")
    private List<InvestigationType> investigationTypes;

    /**
     * Instruments this facility has.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "facility")
    private List<Instrument> instruments;

    /**
     * Sample types this facility has.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "facility")
    private List<SampleType> sampleTypes;

    public Facility() {
        facilityCycles = new ArrayList<>();
        investigations = new ArrayList<>();
        investigationTypes = new ArrayList<>();
        instruments = new ArrayList<>();
        sampleTypes = new ArrayList<>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getDaysUntilRelease() {
        return daysUntilRelease;
    }

    public void setDaysUntilRelease(Integer daysUntilRelease) {
        this.daysUntilRelease = daysUntilRelease;
    }

    @XmlTransient
    public List<FacilityCycle> getFacilityCycles() {
        return facilityCycles;
    }

    public void setFacilityCycles(List<FacilityCycle> facilityCycles) {
        this.facilityCycles = facilityCycles;
    }

    @XmlTransient
    public List<Investigation> getInvestigations() {
        return investigations;
    }

    public void setInvestigations(List<Investigation> investigations) {
        this.investigations = investigations;
    }

    public List<Instrument> getInstruments() {
        return instruments;
    }

    public void setInstruments(List<Instrument> instruments) {
        this.instruments = instruments;
    }

    public List<InvestigationType> getInvestigationTypes() {
        return investigationTypes;
    }

    public void setInvestigationTypes(List<InvestigationType> investigationTypes) {
        this.investigationTypes = investigationTypes;
    }

    @XmlTransient
    public List<SampleType> getSampleTypes() {
        return sampleTypes;
    }

    public void setSampleTypes(List<SampleType> sampleTypes) {
        this.sampleTypes = sampleTypes;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Facility)) {
            return false;
        }
        Facility other = (Facility) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
