/*
 *
 */
package cn.ac.csns.portal.proposalsystem.entity;

import cn.ac.csns.common.utils.constraint.Email;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * A user of the facility.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(name = "USER_", uniqueConstraints = {
    @UniqueConstraint(columnNames = {"NAME"})})
@NamedQueries({
    @NamedQuery(name = "User.findByName",
            query = "SELECT u FROM User u WHERE u.name = :name"),
    @NamedQuery(name = "User.findByEmail",
            query = "SELECT u FROM User u WHERE u.email = :email")})
public class User extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;
    
    public static final String FIND_BY_NAME = "User.findByName";
    public static final String FIND_BY_EMAIL = "User.findByEmail";

    /**
     * The name of the user.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * The full name.
     */
    @Size(max = 255)
    private String fullName;

    /**
     * Email address.
     */
    @Email
    @Size(max = 255)
    private String email;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "user")
    private List<UserGroup> userGroups;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "user")
    private List<InvestigationUser> investigationUsers;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "user")
    private List<InstrumentScientist> instrumentScientists;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "user")
    private List<Study> studies;

    public User() {
        userGroups = new ArrayList<>();
        investigationUsers = new ArrayList<>();
        instrumentScientists = new ArrayList<>();
        studies = new ArrayList<>();
    }

    /**
     * Get the value of studies
     *
     * @return the value of studies
     */
    public List<Study> getStudies() {
        return studies;
    }

    /**
     * Set the value of studies
     *
     * @param studies new value of studies
     */
    public void setStudies(List<Study> studies) {
        this.studies = studies;
    }

    /**
     * Get the value of instrumentScientists
     *
     * @return the value of instrumentScientists
     */
    public List<InstrumentScientist> getInstrumentScientists() {
        return instrumentScientists;
    }

    /**
     * Set the value of instrumentScientists
     *
     * @param instrumentScientists new value of instrumentScientists
     */
    public void setInstrumentScientists(List<InstrumentScientist> instrumentScientists) {
        this.instrumentScientists = instrumentScientists;
    }

    /**
     * Get the value of investigationUsers
     *
     * @return the value of investigationUsers
     */
    public List<InvestigationUser> getInvestigationUsers() {
        return investigationUsers;
    }

    /**
     * Set the value of investigationUsers
     *
     * @param investigationUsers new value of investigationUsers
     */
    public void setInvestigationUsers(List<InvestigationUser> investigationUsers) {
        this.investigationUsers = investigationUsers;
    }

    /**
     * Get the value of userGroups
     *
     * @return the value of userGroups
     */
    public List<UserGroup> getUserGroups() {
        return userGroups;
    }

    /**
     * Set the value of userGroups
     *
     * @param userGroups new value of userGroups
     */
    public void setUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    /**
     * Get the value of email
     *
     * @return the value of email
     */
    public String getEmail() {
        return email;
    }

    /**
     * Set the value of email
     *
     * @param email new value of email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Get the value of fullName
     *
     * @return the value of fullName
     */
    public String getFullName() {
        return fullName;
    }

    /**
     * Set the value of fullName
     *
     * @param fullName new value of fullName
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    /**
     * Get the value of name
     *
     * @return the value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the value of name
     *
     * @param name new value of name
     */
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof User)) {
            return false;
        }
        User other = (User) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
