/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * A kind type of sample.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"FACILITY_ID", "NAME", "MOLECULARFORMULA"})})
@NamedQueries({
    @NamedQuery(name = "SampleType.findByName",
            query = "SELECT st FROM SampleType st WHERE st.name = :name"),
    @NamedQuery(name = "SampleType.findByMolecularFormula",
            query = "SELECT st FROM SampleType st WHERE st.molecularFormula = :molecularFormula")})
public class SampleType extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_NAME = "SampleType.findByName";
    public static final String FIND_BY_MOLECULAR_FORMULA = "SampleType.findByMolecularFormula";

    /**
     * The name of this kind of sample.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * The formula written as a string. E.g. H2O.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String molecularFormula;

    /**
     * Any safety information related to this sample.
     */
    @Size(max = 4000)
    @Column(length = 4000)
    private String safetyInformation;

    /**
     * The facility which has defined this sample type.
     */
    @JoinColumn(name = "FACILITY_ID", nullable = false)
    @ManyToOne
    private Facility facility;

    /**
     * Samples of this kind of type.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "type")
    private List<Sample> samples;

    public SampleType() {
        samples = new ArrayList<>();
    }

    /**
     * Get the value of name
     *
     * @return the value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the value of name
     *
     * @param name new value of name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Get the value of molecularFormula
     *
     * @return the value of molecularFormula
     */
    public String getMolecularFormula() {
        return molecularFormula;
    }

    /**
     * Set the value of molecularFormula
     *
     * @param molecularFormula new value of molecularFormula
     */
    public void setMolecularFormula(String molecularFormula) {
        this.molecularFormula = molecularFormula;
    }

    /**
     * Get the value of safetyInformation
     *
     * @return the value of safetyInformation
     */
    public String getSafetyInformation() {
        return safetyInformation;
    }

    /**
     * Set the value of safetyInformation
     *
     * @param safetyInformation new value of safetyInformation
     */
    public void setSafetyInformation(String safetyInformation) {
        this.safetyInformation = safetyInformation;
    }

    /**
     * Get the value of facility
     *
     * @return the value of facility
     */
    public Facility getFacility() {
        return facility;
    }

    /**
     * Set the value of facility
     *
     * @param facility new value of facility
     */
    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    /**
     * Get the value of samples
     *
     * @return the value of samples
     */
    public List<Sample> getSamples() {
        return samples;
    }

    /**
     * Set the value of samples
     *
     * @param samples new value of samples
     */
    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof SampleType)) {
            return false;
        }
        SampleType other = (SampleType) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
