/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * A group of users.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(name = "GROUP_", uniqueConstraints = {
    @UniqueConstraint(columnNames = {"NAME"})})
@NamedQueries({
    @NamedQuery(name = "Grouping.findByName", query = "SELECT g FROM Grouping g WHERE g.name = :name")})
public class Grouping extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_NAME = "Grouping.findByName";

    /**
     * A short name identifying this group of users.
     */
    @Basic(optional = false)
    @Size(min = 1, max = 255)
    @NotNull
    @Column(nullable = false)
    private String name;

    @OneToMany(mappedBy = "grouping", cascade = CascadeType.ALL)
    private List<InvestigationGroup> investigationGroups;

    @OneToMany(mappedBy = "grouping", cascade = CascadeType.ALL)
    private List<UserGroup> userGroups;

    public Grouping() {
        investigationGroups = new ArrayList<>();
        userGroups = new ArrayList<>();
    }

    /**
     * Get the value of name
     *
     * @return the value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the value of name
     *
     * @param name new value of name
     */
    public void setName(String name) {
        this.name = name;
    }

    public List<InvestigationGroup> getInvestigationGroups() {
        return investigationGroups;
    }

    public void setInvestigationGroups(List<InvestigationGroup> investigationGroups) {
        this.investigationGroups = investigationGroups;
    }

    public List<UserGroup> getUserGroups() {
        return userGroups;
    }

    public void setUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Grouping)) {
            return false;
        }
        Grouping other = (Grouping) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
