/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * An operating cycle within a facility.
 *
 * @author tangm
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"FACILITY_ID", "NAME"})})
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "FacilityCycle.findByName", query = "SELECT f FROM FacilityCycle f WHERE f.name = :name"),
    @NamedQuery(name = "FacilityCycle.findByStartDate", query = "SELECT f FROM FacilityCycle f WHERE f.startDate = :startDate"),
    @NamedQuery(name = "FacilityCycle.findByEndDate", query = "SELECT f FROM FacilityCycle f WHERE f.endDate = :endDate"),
    @NamedQuery(name = "FacilityCycle.findByCreateTime", query = "SELECT f FROM FacilityCycle f WHERE f.createTime = :createTime"),
    @NamedQuery(name = "FacilityCycle.findByFacility", query = "SELECT f FROM FacilityCycle f WHERE f.facility = :facility")})
public class FacilityCycle extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_NAME = "FacilityCycle.findByName";
    public static final String FIND_BY_START_DATE = "FacilityCycle.findByStartDate";
    public static final String FIND_BY_END_DATE = "FacilityCycle.findByEndDate";
    public static final String FIND_BY_CREATE_TIME = "FacilityCycle.findByCreateTime";
    public static final String FIND_BY_FACILITY = "FacilityCycle.findByFacility";

    /**
     * A short name identifying this facility cycle.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String name;

    /**
     * A description of this facility cycle.
     */
    @Size(max = 255)
    @Column
    private String description;

    /**
     * Start of cycle.
     */
    @Column
    @Temporal(TemporalType.TIMESTAMP)
    private Date startDate;

    /**
     * End of cycle.
     */
    @Column
    @Temporal(TemporalType.TIMESTAMP)
    private Date endDate;

    /**
     * The facility which has this cycle.
     */
    @JoinColumn(name = "FACILITY_ID", referencedColumnName = "ID", nullable = false)
    @ManyToOne(optional = false)
    private Facility facility;

    /**
     * The investigations belong to this cycle.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "facilityCycle")
    private List<Investigation> investigations;

    public FacilityCycle() {
        investigations = new ArrayList<>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Facility getFacility() {
        return facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    @XmlTransient
    public List<Investigation> getInvestigations() {
        return investigations;
    }

    public void setInvestigations(List<Investigation> investigations) {
        this.investigations = investigations;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof FacilityCycle)) {
            return false;
        }
        FacilityCycle other = (FacilityCycle) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
