/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Study;
import cn.ac.csns.portal.proposalsystem.entity.User;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.StudyFacade;
import cn.ac.csns.portal.proposalsystem.facade.UserFacade;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.transaction.Transactional;
import org.primefaces.event.RowEditEvent;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class StudyController implements Serializable {

    private Study current;
    private List<Study> studies;
    private String currentUser;

    @EJB
    private StudyFacade facade;
    @EJB
    private UserFacade userFacade;

    /**
     * Creates a new instance of FacilityController
     */
    public StudyController() {
        current = new Study();
    }

    @PostConstruct
    private void init() {
        currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        fresh();
    }

    @Transactional
    public void add() {
        Date now = new Date();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        String message;
        try {
            User user = userFacade.findByName(currentUser);
            current.setUser(user);
            facade.create(current);
            facade.flush();
            fresh();
            message = "Study added successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(StudyController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add study.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        current = new Study();
    }

    public void remove(Study study) {
        String message;
        try {
            facade.remove(study);
            fresh();
            message = "Study removed: " + study.getName();
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove study: " + study.getName();
            Logger.getLogger(StudyController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public void onRowEditInit(RowEditEvent event) {
        String text = ((Study) event.getObject()).toString();
        FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_INFO, "Study Editing", text);
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }

    public void onRowEdit(RowEditEvent event) {
        FacesMessage msg;
        Study studyEdited = (Study) event.getObject();
        String text = studyEdited.toString();
        studyEdited.setModTime(new Date());
        try {
            facade.edit(studyEdited);
            fresh();
            msg = new FacesMessage(FacesMessage.SEVERITY_INFO, "Study Edited", text);
            FacesContext.getCurrentInstance().addMessage(null, msg);
        } catch (IpsException ex) {
            Logger.getLogger(StudyController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL,
                                    "Study Edit Failed",
                                    ex.getMessage()
                            )
                    );
        }
    }

    public void onRowCancel(RowEditEvent event) {
        FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_INFO, "Study Edit Canceled", "Edit canceled!");
        FacesContext.getCurrentInstance().addMessage(null, msg);
    }

    public void fresh() {
        try {
            studies = facade.findByUserName(currentUser);
            studies.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        } catch (IpsException ex) {
            Logger.getLogger(StudyController.class.getName()).log(Level.SEVERE, null, ex);
            String message = "Error occurred when retriving studies.";
            Logger.getLogger(StudyController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public Study getCurrent() {
        return current;
    }

    public void setCurrent(Study current) {
        this.current = current;
    }

    public List<Study> getStudies() {
        return studies;
    }

}
