/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Facility;
import cn.ac.csns.portal.proposalsystem.entity.FacilityCycle;
import cn.ac.csns.portal.proposalsystem.entity.Instrument;
import cn.ac.csns.portal.proposalsystem.entity.Investigation;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationInstrument;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationStatus;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationType;
import cn.ac.csns.portal.proposalsystem.entity.Keyword;
import cn.ac.csns.portal.proposalsystem.entity.Sample;
import cn.ac.csns.portal.proposalsystem.entity.SampleType;
import cn.ac.csns.portal.proposalsystem.entity.Study;
import cn.ac.csns.portal.proposalsystem.entity.StudyInvestigation;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.InvestigationFacade;
import cn.ac.csns.portal.proposalsystem.util.EntityCreateTimeComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.flow.FlowScoped;
import javax.inject.Inject;
import org.primefaces.event.SelectEvent;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@FlowScoped("createproposal")
public class CreateProposalController implements Serializable {

    private static final String KEYWORDS_SEPARATOR = ",";

    private String keywordsStr;
    private String user;

    private Investigation newInvestigation;
    private List<Sample> samples;
    private Facility facility;
    private List<FacilityCycle> filteredFacilityCycles;
    private List<InvestigationType> filteredInvestigationTypes;
    private List<Instrument> filteredInstruments;
    private List<SampleType> filteredSampleTypes;
    private Instrument preferredInstrument;
    private List<Study> studies;
    private Study selectedStudy;

    @Inject
    private AppDataController appData;
    @EJB
    private InvestigationFacade facade;

    /**
     * Creates a new instance of CreateProposalController
     */
    public CreateProposalController() {
        newInvestigation = new Investigation();
        samples = new ArrayList<>();
        studies = new ArrayList<>();
    }

    @PostConstruct
    private void init() {
        user = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        if (!appData.getFacilities().isEmpty()) {
            facility = appData.getFacilities().get(0);
            doFilter();
        }
        Date current = new Date();
        newInvestigation.setCreateId(user);
        newInvestigation.setCreateTime(current);
        newInvestigation.setModId(user);
        newInvestigation.setModTime(current);
        newInvestigation.setStatus(InvestigationStatus.NEW);
    }

    public void onSampleAdd(SelectEvent event) {
        if (null == event.getObject() || !(event.getObject() instanceof Sample)) {
            return;
        }
        Sample newSample = (Sample) event.getObject();
        samples.add(newSample);
    }

    public void doFilter() {
        filteredFacilityCycles = filterFacilityCycles(facility);
        filteredInvestigationTypes = filterInvestigationTypes(facility);
        filteredInstruments = filterInstruments(facility);
        filteredSampleTypes = filterSampleType(facility);
    }

    public void addStudy() {
        if (selectedStudy == null) {
            return;
        }
        if (studies.contains(selectedStudy)) {
            return;
        }
        studies.add(selectedStudy);
    }

    public void removeStudy(Study study) {
        try {
            studies.remove(study);
        } catch (Exception ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public String resetStudies() {
        studies = new ArrayList<>();
        saveStudy();
        return "";
    }

    private List<FacilityCycle> filterFacilityCycles(Facility selectedFacility) {
        List<FacilityCycle> filteredFCs = new ArrayList<>();
        appData.getFacilityCycles().stream()
                .filter((fc) -> (fc.getFacility().equals(selectedFacility)))
                .sorted(new EntityCreateTimeComparator<>(true))
                .forEach((fc) -> {
                    filteredFCs.add(fc);
                });
        return filteredFCs;
    }

    private List<InvestigationType> filterInvestigationTypes(Facility selectedFacility) {
        List<InvestigationType> filteredITs = new ArrayList<>();
        appData.getInvestigationTypes().stream()
                .filter((it) -> (it.getFacility().equals(selectedFacility)))
                .forEach((it) -> {
                    filteredITs.add(it);
                });
        return filteredITs;
    }

    private List<Instrument> filterInstruments(Facility selectedFacility) {
        return appData.getInstruments().stream()
                .filter(ins -> ins.getFacility().equals(selectedFacility))
                .collect(Collectors.toList());
    }

    private List<SampleType> filterSampleType(Facility selectedFacility) {
        return appData.getSampleTypes().stream()
                .filter(st -> st.getFacility().equals(selectedFacility))
                .sorted((SampleType o1, SampleType o2)
                        -> o1.getName().compareToIgnoreCase(o2.getName()))
                .collect(Collectors.toList());
    }

    public void removeSample(Sample sample) {
        try {
            samples.remove(sample);
        } catch (Exception ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    private List<String> processKeywordsStr() {
        return Arrays.<String>asList(keywordsStr.split(KEYWORDS_SEPARATOR))
                .stream().map(String::trim)
                .filter(item -> !item.isEmpty())
                .distinct().collect(Collectors.toList());
    }

    private List<Keyword> createInvetigationKeywords(List<String> keywordsList) {
        List<Keyword> keywords = new ArrayList<>();
        Date current = new Date();
        keywordsList.stream().forEach(item -> {
            Keyword keyword = new Keyword();
            keyword.setCreateId(user);
            keyword.setCreateTime(current);
            keyword.setModId(user);
            keyword.setModTime(current);
            keyword.setName(item);
            keyword.setInvestigation(newInvestigation);
            keywords.add(keyword);
        });
        return keywords;
    }

    public String saveBasic() {
        List<String> keywordsList = processKeywordsStr();
        List<Keyword> keywords = createInvetigationKeywords(keywordsList);
        newInvestigation.setFacility(facility);
        newInvestigation.setKeywords(keywords);
        return "";
    }

    public String saveInstrument() {
        List<InvestigationInstrument> investigationInstruments = new ArrayList<>();
        Date current = new Date();
        InvestigationInstrument investigationInstrument = new InvestigationInstrument();
        investigationInstrument.setCreateId(user);
        investigationInstrument.setCreateTime(current);
        investigationInstrument.setModId(user);
        investigationInstrument.setModTime(current);
        investigationInstrument.setInstrument(preferredInstrument);
        investigationInstrument.setInvestigation(newInvestigation);
        investigationInstruments.add(investigationInstrument);
        newInvestigation.setInvestigationInstruments(investigationInstruments);
        return "";
    }

    public String saveSample() {
        if (samples.isEmpty()) {
            return "";
        }
        samples.stream().forEach((s) -> {
            s.setInvestigation(newInvestigation);
        });
        newInvestigation.setSamples(samples);
        return "";
    }

    public String saveStudy() {
        List<StudyInvestigation> studyInvestigations = new ArrayList<>();
        Date current = new Date();
        studies.stream().forEach((s) -> {
            StudyInvestigation studyInvestigation = new StudyInvestigation();
            studyInvestigation.setCreateId(user);
            studyInvestigation.setCreateTime(current);
            studyInvestigation.setModId(user);
            studyInvestigation.setModTime(current);
            studyInvestigation.setInvestigation(newInvestigation);
            studyInvestigation.setStudy(s);
            studyInvestigations.add(studyInvestigation);
        });
        newInvestigation.setStudyInvestigations(studyInvestigations);
        FacesContext.getCurrentInstance()
                .addMessage(null,
                        new FacesMessage(FacesMessage.SEVERITY_INFO,
                                "Studies Saved", "Studies Saved"));
        return "";
    }

    public String save() {
        try {
            facade.create(newInvestigation);
        } catch (IpsException ex) {
            String message = "Error occurred.";
            Logger.getLogger(CreateProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        return "";
    }

    public Investigation getNewInvestigation() {
        return newInvestigation;
    }

    public void setNewInvestigation(Investigation newInvestigation) {
        this.newInvestigation = newInvestigation;
    }

    public String getKeywordsStr() {
        return keywordsStr;
    }

    public void setKeywordsStr(String keywordsStr) {
        this.keywordsStr = keywordsStr;
    }

    public List<Sample> getSamples() {
        return samples;
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    public Facility getFacility() {
        return facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    public List<FacilityCycle> getFilteredFacilityCycles() {
        return filteredFacilityCycles;
    }

    public List<InvestigationType> getFilteredInvestigationTypes() {
        return filteredInvestigationTypes;
    }

    public List<Instrument> getFilteredInstruments() {
        return filteredInstruments;
    }

    public Instrument getPreferredInstrument() {
        return preferredInstrument;
    }

    public List<SampleType> getFilteredSampleTypes() {
        return filteredSampleTypes;
    }

    public void setPreferredInstrument(Instrument preferredInstrument) {
        this.preferredInstrument = preferredInstrument;
    }

    public List<Study> getStudies() {
        return studies;
    }

    public Study getSelectedStudy() {
        return selectedStudy;
    }

    public void setSelectedStudy(Study selectedStudy) {
        this.selectedStudy = selectedStudy;
    }

}
