/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.Version;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlTransient;

/**
 * Entity base class with common properties.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@MappedSuperclass
public abstract class EntityBase implements Serializable {
    private static final long serialVersionUID = 1L;
    
    /**
     * ID.
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    protected Long id;

    /**
     * Creator ID.
     */
    @Basic(optional = false)
    @Column(name = "CREATE_ID", nullable = false, length = 30)
    @Size(min = 1, max = 30)
    protected String createId;

    /**
     * Created time.
     */
    @Basic(optional = false)
    @Temporal(javax.persistence.TemporalType.TIMESTAMP)
    @Column(name = "CREATE_TIME", nullable = false)
    protected Date createTime;

    /**
     * Modifier ID.
     */
    @Basic(optional = false)
    @Column(name = "MOD_ID", nullable = false, length = 30)
    @Size(min = 1, max = 30)
    protected String modId;

    /**
     * Last modified time.
     */
    @Basic(optional = false)
    @Temporal(javax.persistence.TemporalType.TIMESTAMP)
    @Column(name = "MOD_TIME", nullable = false)
    protected Date modTime;

    /**
     * Concurrent version.
     */
    @XmlTransient
    @Version
    @Column(name = "CONCURRENT_VERSION")
    protected Long conVersion;

    /**
     * Get the value of ID.
     *
     * @return the value of ID
     */
    public Long getId() {
        return id;
    }

    /**
     * Set the value of ID.
     * 
     * @param id new value of ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Get the value of createId
     *
     * @return the value of createId
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * Set the value of createId
     *
     * @param createId new value of createId
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * Get the value of modId
     *
     * @return the value of modId
     */
    public String getModId() {
        return modId;
    }

    /**
     * Set the value of modId
     *
     * @param modId new value of modId
     */
    public void setModId(String modId) {
        this.modId = modId;
    }

    /**
     * Get the value of modTime.
     *
     * @return the value of modTime
     */
    public Date getModTime() {
        return modTime;
    }

    /**
     * Set the value of modTime.
     *
     * @param modTime new value of modTime
     */
    public void setModTime(Date modTime) {
        this.modTime = modTime;
    }

    /**
     * Get the value of createTime.
     *
     * @return the value of createTime
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * Set the value of createTime.
     *
     * @param createTime new value of createTime
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * Get the value of conVersion
     *
     * @return the value of conVersion
     */
    public Long getConVersion() {
        return conVersion;
    }

    /**
     * Set the value of conVersion
     *
     * @param conVersion new value of conVersion
     */
    public void setConVersion(Long conVersion) {
        this.conVersion = conVersion;
    }
}
