/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 * Investigation entity.
 *
 * @author tangm
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"FACILITY_ID", "NAME"})})
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Investigation.findByTitle",
            query = "SELECT p FROM Investigation p WHERE p.title = :title"),
    @NamedQuery(name = "Investigation.findByCreateId",
            query = "SELECT p FROM Investigation p WHERE p.createId = :createId"),
    @NamedQuery(name = "Investigation.findByCreateTime",
            query = "SELECT p FROM Investigation p WHERE p.createTime = :createTime"),
    @NamedQuery(name = "Investigation.findByName",
            query = "SELECT p FROM Investigation p WHERE p.name = :name"),
    @NamedQuery(name = "Investigation.findByModTime",
            query = "SELECT p FROM Investigation p WHERE p.modTime = :modTime"),
    @NamedQuery(name = "Investigation.findByFacility",
            query = "SELECT p FROM Investigation p WHERE p.facility = :facility"),
    @NamedQuery(name = "Investigation.findByFacilityCycle",
            query = "SELECT p FROM Investigation p WHERE p.facilityCycle = :facilityCycle"),
    @NamedQuery(name = "Investigation.findByStatus",
            query = "SELECT p FROM Investigation p WHERE p.status = :status"),
    @NamedQuery(name = "Investigation.findByType",
            query = "SELECT p FROM Investigation p WHERE p.type = :type"),
    @NamedQuery(name = "Investigation.findByKeyword",
            query = "SELECT p FROM Investigation p join p.keywords k WHERE k = :keyword"),
    @NamedQuery(name = "Investigation.findByGroup",
            query = "SELECT p FROM Investigation p JOIN p.investigationGroups ig JOIN ig.group g WHERE g = :group"),
    @NamedQuery(name = "Investigation.findByInstrument",
            query = "SELECT p FROM Investigation p JOIN p.investigationInstruments ii JOIN ii.instrument i WHERE i = :instrument"),
    @NamedQuery(name = "Investigation.findByUser",
            query = "SELECT p FROM Investigation p JOIN p.investigationUsers iu JOIN iu.user u WHERE u = :user"),
    @NamedQuery(name = "Investigation.findByStudy",
            query = "SELECT p FROM Investigation p JOIN p.studyInvestigations si JOIN si.study s WHERE s = :study")})
@NamedEntityGraphs({
    @NamedEntityGraph(name = "investigationWithAllInfo", includeAllAttributes = true),
    @NamedEntityGraph(name = "investigationWithDetails", attributeNodes = {
        @NamedAttributeNode("createId"),
        @NamedAttributeNode("createTime"),
        @NamedAttributeNode("modId"),
        @NamedAttributeNode("modTime"),
        @NamedAttributeNode("id"),
        @NamedAttributeNode("facility"),
        @NamedAttributeNode("facilityCycle"),
        @NamedAttributeNode("investigationGroups"),
        @NamedAttributeNode("investigationInstruments"),
        @NamedAttributeNode("investigationUsers"),
        @NamedAttributeNode("keywords"),
        @NamedAttributeNode("name"),
        @NamedAttributeNode("samples"),
        @NamedAttributeNode("status"),
        @NamedAttributeNode("studyInvestigations"),
        @NamedAttributeNode("summary"),
        @NamedAttributeNode("title"),
        @NamedAttributeNode("type")}),
    @NamedEntityGraph(name = "investigationWithReview", attributeNodes = {
        @NamedAttributeNode("createId"),
        @NamedAttributeNode("createTime"),
        @NamedAttributeNode("modId"),
        @NamedAttributeNode("modTime"),
        @NamedAttributeNode("id"),
        @NamedAttributeNode("expertInvestigations"),
        @NamedAttributeNode("reviews")})})
public class Investigation extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_TITLE = "Investigation.findByTitle";
    public static final String FIND_BY_CREATE_ID = "Investigation.findByCreateId";
    public static final String FIND_BY_CREATE_TIME = "Investigation.findByCreateTime";
    public static final String FIND_BY_NAME = "Investigation.findByName";
    public static final String FIND_BY_MOD_TIME = "Investigation.findByModTime";
    public static final String FIND_BY_FACILITY = "Investigation.findByFacility";
    public static final String FIND_BY_FACILITY_CYCLE = "Investigation.findByFacilityCycle";
    public static final String FIND_BY_STATUS = "Investigation.findByStatus";
    public static final String FIND_BY_TYPE = "Investigation.findByType";
    public static final String FIND_BY_KEYWORD = "Investigation.findByKeyword";
    public static final String FIND_BY_GROUP = "Investigation.findByGroup";
    public static final String FIND_BY_INSTRUMENT = "Investigation.findByInstrument";
    public static final String FIND_BY_USER = "Investigation.findByUser";
    public static final String FIND_BY_STUDY = "Investigation.findByStudy";
    public static final String GRAPH_INVESTIGATION_WITH_ALL_INFO = "investigationWithAllInfo";
    public static final String GRAPH_INVESTIGATION_WITH_DETAILS = "investigationWithDetails";
    public static final String GRAPH_INVESTIGATION_WITH_REVIEW = "investigationWithReview";
    /**
     * Entity load graph. GlassFish server doesn't support this entity graph
     * type.
     */
    public static final String LOAD_GRAPH = "javax.persistence.loadgraph";
    /**
     * Entity fetch graph.
     */
    public static final String FETCH_GRAPH = "javax.persistence.fetchgraph";

    /**
     * Full title of the investigation.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String title;

    /**
     * Summary or abstract.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 4000)
    @Column(length = 4000, nullable = false)
    private String summary;

    /**
     * A short name for the investigation.
     */
    @Basic(optional = false)
    @Size(min = 1, max = 255)
    @NotNull
    @Column(nullable = false)
    private String name;

    /**
     * Investigation type.
     */
    @JoinColumn(name = "TYPE_ID", referencedColumnName = "ID", nullable = false)
    @ManyToOne(optional = false)
    private InvestigationType type;

    /**
     * Investigation status.
     */
    @Basic(optional = false)
    @NotNull
    @Enumerated(EnumType.STRING)
    @Column(length = 12, nullable = false)
    private InvestigationStatus status;

    @JoinColumn(name = "FACILITY_ID", referencedColumnName = "ID", nullable = false)
    @ManyToOne(optional = false)
    private Facility facility;

    @JoinColumn(name = "FACILITYCYCLE_ID", referencedColumnName = "ID", nullable = false)
    @ManyToOne(optional = false)
    private FacilityCycle facilityCycle;

    /**
     * Samples.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<Sample> samples;

    /**
     * Investigation groups.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<InvestigationGroup> investigationGroups;

    /**
     * Investigation instruments.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<InvestigationInstrument> investigationInstruments;

    /**
     * Investigation users.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<InvestigationUser> investigationUsers;

    /**
     * Keywords.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<Keyword> keywords;

    /**
     * Study investigations.
     */
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<StudyInvestigation> studyInvestigations;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<Review> reviews;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "investigation", orphanRemoval = true)
    private List<ExpertInvestigation> expertInvestigations;

    public Investigation() {
        samples = new ArrayList<>();
        investigationGroups = new ArrayList<>();
        investigationInstruments = new ArrayList<>();
        investigationUsers = new ArrayList<>();
        keywords = new ArrayList<>();
        studyInvestigations = new ArrayList<>();
        reviews = new ArrayList<>();
        expertInvestigations = new ArrayList<>();
    }

    /**
     * Get the value of expertInvestigations
     *
     * @return the value of expertInvestigations
     */
    public List<ExpertInvestigation> getExpertInvestigations() {
        return expertInvestigations;
    }

    /**
     * Set the value of expertInvestigations
     *
     * @param expertInvestigations new value of expertInvestigations
     */
    public void setExpertInvestigations(List<ExpertInvestigation> expertInvestigations) {
        this.expertInvestigations = expertInvestigations;
    }

    /**
     * Get the value of reviews
     *
     * @return the value of reviews
     */
    public List<Review> getReviews() {
        return reviews;
    }

    /**
     * Set the value of reviews
     *
     * @param reviews new value of reviews
     */
    public void setReviews(List<Review> reviews) {
        this.reviews = reviews;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InvestigationType getType() {
        return type;
    }

    public void setType(InvestigationType type) {
        this.type = type;
    }

    public InvestigationStatus getStatus() {
        return status;
    }

    public void setStatus(InvestigationStatus status) {
        this.status = status;
    }

    public Facility getFacility() {
        return facility;
    }

    public void setFacility(Facility facility) {
        this.facility = facility;
    }

    @XmlTransient
    public List<Sample> getSamples() {
        return samples;
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    public FacilityCycle getFacilityCycle() {
        return facilityCycle;
    }

    public void setFacilityCycle(FacilityCycle facilityCycle) {
        this.facilityCycle = facilityCycle;
    }

    public List<InvestigationGroup> getInvestigationGroups() {
        return investigationGroups;
    }

    public void setInvestigationGroups(List<InvestigationGroup> investigationGroups) {
        this.investigationGroups = investigationGroups;
    }

    public List<InvestigationInstrument> getInvestigationInstruments() {
        return investigationInstruments;
    }

    public void setInvestigationInstruments(List<InvestigationInstrument> investigationInstruments) {
        this.investigationInstruments = investigationInstruments;
    }

    public List<InvestigationUser> getInvestigationUsers() {
        return investigationUsers;
    }

    public void setInvestigationUsers(List<InvestigationUser> investigationUsers) {
        this.investigationUsers = investigationUsers;
    }

    public List<Keyword> getKeywords() {
        return keywords;
    }

    public void setKeywords(List<Keyword> keywords) {
        this.keywords = keywords;
    }

    public List<StudyInvestigation> getStudyInvestigations() {
        return studyInvestigations;
    }

    public void setStudyInvestigations(List<StudyInvestigation> studyInvestigations) {
        this.studyInvestigations = studyInvestigations;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Investigation)) {
            return false;
        }
        Investigation other = (Investigation) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + ", name=" + name + " ]";
    }

}
