/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.SampleType;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.SampleTypeFacade;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class SampleTypeController implements Serializable {

    private SampleType current;
    private String[] safetyInfo;
    private String otherInfo;

    @Inject
    private AppDataController appData;

    @EJB
    private SampleTypeFacade facade;

    /**
     * Creates a new instance of FacilityController
     */
    public SampleTypeController() {
        current = new SampleType();
    }

    private String processSaftyInformation() {
        StringBuilder sb = new StringBuilder();
        if (null != safetyInfo && safetyInfo.length > 0) {
            Arrays.asList(safetyInfo).stream()
                    .forEach(item -> {
                        sb.append(item.trim());
                        sb.append("; ");
                    });
        }
        if (null != otherInfo && !otherInfo.trim().isEmpty()) {
            sb.append(otherInfo.trim());
        }
        return sb.toString();
    }

    private void clear() {
        current = new SampleType();
        safetyInfo = null;
        otherInfo = null;
    }

    @Transactional
    public void add() {
        Date now = new Date();
        String currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        current.setSafetyInformation(processSaftyInformation());
        String message;
        try {
            facade.create(current);
            facade.flush();
            appData.freshSampleTypes();
            message = "Sample type added successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(SampleTypeController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add sample type.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        clear();
    }

    public void remove(SampleType investigationType) {
        String message;
        try {
            facade.remove(investigationType);
            appData.freshSampleTypes();
            message = "Sample type removed: " + investigationType.getName();
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove sample type: " + investigationType.getName();
            Logger.getLogger(SampleTypeController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public SampleType getCurrent() {
        return current;
    }

    public void setCurrent(SampleType current) {
        this.current = current;
    }

    public String[] getSafetyInfo() {
        return safetyInfo;
    }

    public void setSafetyInfo(String[] safetyInfo) {
        this.safetyInfo = safetyInfo;
    }

    public String getOtherInfo() {
        return otherInfo;
    }

    public void setOtherInfo(String otherInfo) {
        this.otherInfo = otherInfo;
    }

}
