/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Investigation;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationStatus;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.InvestigationFacade;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.transaction.Transactional;

/**
 * Submit proposals controller.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class SubmitProposalController implements Serializable {

    private List<Investigation> investigations;
    private String currentUser;

    @EJB
    private InvestigationFacade facade;

    /**
     * Creates a new instance of ConfirmProposalController
     */
    public SubmitProposalController() {
    }

    @PostConstruct
    private void init() {
        try {
            currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
            investigations = facade.findByCreator(currentUser)
                    .stream()
                    .filter(iv -> iv.getStatus().equals(InvestigationStatus.NEW))
                    .sorted((o1, o2) -> {
                        return o2.getCreateTime().compareTo(o1.getCreateTime());
                    })
                    .collect(Collectors.toList());
        } catch (IpsException ex) {
            investigations = new ArrayList<>();
            Logger.getLogger(SubmitProposalController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public String doView(Investigation investigation) {
        Map<String, Object> sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        sessionMap.put(Constant.CURRENT_VIEWING_INVESTIGATION, investigation);
        return "/viewproposal?faces-redirect=true";
    }

    public String doEdit(Investigation investigation) {
        Map<String, Object> sessionMap = FacesContext.getCurrentInstance()
                .getExternalContext().getSessionMap();
        sessionMap.put(Constant.CURRENT_EDITING_INVESTIGATION, investigation);
        return "/editproposal?faces-redirect=true";
    }

    @Transactional
    public String doSubmit(Investigation investigation) {
        String message;
        if (investigation.getStatus().equals(InvestigationStatus.SUBMITTED)) {
            message = "Investigation " + investigation.getId() + " already submited";
            FacesContext.getCurrentInstance()
                    .addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
            return "";
        }
        investigation.setStatus(InvestigationStatus.SUBMITTED);
        try {
            facade.edit(investigation);
            message = "Investigation " + investigation.getId() + " submited successfully";
            FacesContext.getCurrentInstance()
                    .addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(SubmitProposalController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            message = "Investigation " + investigation.getId() + " submited failed";
            FacesContext.getCurrentInstance()
                    .addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        return "";
    }

    public String doRemove(Investigation investigation) {
        try {
            facade.remove(investigation);
            investigations.remove(investigation);
        } catch (IpsException ex) {
            Logger.getLogger(SubmitProposalController.class.getName()).log(Level.SEVERE, null, ex);
            String message = "Investigation " + investigation.getId() + " remove failed";
            FacesContext.getCurrentInstance()
                    .addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
            return "";
        }
        return "";
    }

    public List<Investigation> getInvestigations() {
        return investigations;
    }

}
