/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Facility;
import cn.ac.csns.portal.proposalsystem.entity.FacilityCycle;
import cn.ac.csns.portal.proposalsystem.entity.Instrument;
import cn.ac.csns.portal.proposalsystem.entity.InstrumentScientist;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationType;
import cn.ac.csns.portal.proposalsystem.entity.SampleType;
import cn.ac.csns.portal.proposalsystem.entity.StudyStatus;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.FacilityCycleFacade;
import cn.ac.csns.portal.proposalsystem.facade.FacilityFacade;
import cn.ac.csns.portal.proposalsystem.facade.InstrumentFacade;
import cn.ac.csns.portal.proposalsystem.facade.InstrumentScientistFacade;
import cn.ac.csns.portal.proposalsystem.facade.InvestigationTypeFacade;
import cn.ac.csns.portal.proposalsystem.facade.SampleTypeFacade;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ApplicationScoped
public class AppDataController {

    private List<Facility> facilities;
    private List<Instrument> instruments;
    private List<InvestigationType> investigationTypes;
    private List<FacilityCycle> facilityCycles;
    private List<SampleType> sampleTypes;
    private List<InstrumentScientist> instrumentScientists;

    @EJB
    private FacilityFacade facilityFacade;
    @EJB
    private InstrumentFacade instrumentFacade;
    @EJB
    private InvestigationTypeFacade investigationTypeFacade;
    @EJB
    private FacilityCycleFacade facilityCycleFacade;
    @EJB
    private SampleTypeFacade sampleTypeFacade;
    @EJB
    private InstrumentScientistFacade instrumentScientistFacade;

    /**
     * Creates a new instance of AppDataController
     */
    public AppDataController() {
    }

    @PostConstruct
    private void init() {
        try {
            facilities = facilityFacade.findAll();
            instruments = instrumentFacade.findAll();
            investigationTypes = investigationTypeFacade.findAll();
            facilityCycles = facilityCycleFacade.findAll();
            sampleTypes = sampleTypeFacade.findAll();
            instrumentScientists = instrumentScientistFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public Facility getFacilityById(Long id) {
        for (Facility f : facilities) {
            if (f.getId().equals(id)) {
                return f;
            }
        }
        return null;
    }

    public void freshFacilities() {
        try {
            facilities = facilityFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public void freshInstruments() {
        try {
            instruments = instrumentFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }
    
    public void freshInvestigationTypes(){
        try {
            investigationTypes = investigationTypeFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }
    
    public void freshFacilityCycles() {
        try {
            facilityCycles = facilityCycleFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }
    
    public void freshSampleTypes() {
        try {
            sampleTypes = sampleTypeFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }
    
    public void freshInstrumentScientists() {
        try {
            instrumentScientists = instrumentScientistFacade.findAll();
        } catch (IpsException ex) {
            Logger.getLogger(AppDataController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public List<Facility> getFacilities() {
        return facilities;
    }

    public void setFacilities(List<Facility> facilities) {
        this.facilities = facilities;
    }

    public List<Instrument> getInstruments() {
        return instruments;
    }

    public void setInstruments(List<Instrument> instruments) {
        this.instruments = instruments;
    }

    public List<InvestigationType> getInvestigationTypes() {
        return investigationTypes;
    }

    public void setInvestigationTypes(List<InvestigationType> investigationTypes) {
        this.investigationTypes = investigationTypes;
    }

    public List<FacilityCycle> getFacilityCycles() {
        return facilityCycles;
    }

    public void setFacilityCycles(List<FacilityCycle> facilityCycles) {
        this.facilityCycles = facilityCycles;
    }

    public List<SampleType> getSampleTypes() {
        return sampleTypes;
    }

    public void setSampleTypes(List<SampleType> sampleTypes) {
        this.sampleTypes = sampleTypes;
    }

    public List<InstrumentScientist> getInstrumentScientists() {
        return instrumentScientists;
    }
    
    public StudyStatus[] getStudyStatuses(){
        return StudyStatus.values();
    }

}
