/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.facade;

import cn.ac.csns.portal.proposalsystem.entity.User;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Stateless
public class UserFacade extends AbstractFacade<User> {

    @PersistenceContext
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public UserFacade() {
        super(User.class);
    }

    public User findByName(String userName) throws IpsException {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("name", userName);
        return findSingleResultByNamedQuery(User.FIND_BY_NAME, parameters);
    }

}
