/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.facade;

import cn.ac.csns.portal.proposalsystem.entity.Study;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Stateless
public class StudyFacade extends AbstractFacade<Study> {

    @PersistenceContext
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public StudyFacade() {
        super(Study.class);
    }
    
    public List<Study> findByUserName(String userName) throws IpsException{
        String jpqlStr = "SELECT s FROM Study s WHERE s.user.name = :userName";
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("userName", userName);
        return findResultListByQuery(jpqlStr, parameters);        
    }
    
}
