/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.util;

import cn.ac.csns.portal.proposalsystem.entity.EntityBase;
import java.util.Comparator;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
public class EntityCreateTimeComparator<T extends EntityBase> implements Comparator<T> {

    private boolean reverse = false;

    /**
     * Constructor. Sort in ascending.
     */
    public EntityCreateTimeComparator() {
    }

    /**
     * Constructor with sort direction.
     * 
     * @param reverse the sort direction. <code>true</code> if descending,
     * <code>false</code> if ascending. 
     */
    public EntityCreateTimeComparator(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public int compare(T o1, T o2) {
        int result;
        if (o1.getCreateTime().equals(o2.getCreateTime())) {
            result = 0;
        } else if (o1.getCreateTime().before(o2.getCreateTime())) {
            result = -1;
        } else {
            result = 1;
        }
        if (reverse) {
            result = -1 * result;
        }
        return result;
    }

}
