/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.converter;

import cn.ac.csns.portal.proposalsystem.entity.InvestigationType;
import cn.ac.csns.portal.proposalsystem.managed.AppDataController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.inject.Named;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@RequestScoped
public class InvestigationTypeConverter implements Converter {

    @Inject
    private AppDataController appData;   
    
    private InvestigationType getInvestigationTypeById(Long id) {
        for (InvestigationType it : appData.getInvestigationTypes()) {
            if (it.getId().equals(id)) {
                return it;
            }
        }
        return null;
    }

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (value != null && !value.trim().isEmpty()) {
            try {
                //return service.find(Long.parseLong(value));
                return getInvestigationTypeById(Long.parseLong(value));
            } catch (NumberFormatException ex) {
                Logger.getLogger(InvestigationTypeConverter.class.getName())
                        .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                FacesContext.getCurrentInstance().addMessage(null,
                        new FacesMessage(FacesMessage.SEVERITY_FATAL,
                                ex.getLocalizedMessage(),
                                ex.getLocalizedMessage()));
                return null;
            }
        } else {
            return null;
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value != null && value instanceof InvestigationType) {
            return String.valueOf(((InvestigationType) value).getId());
        } else {
            return null;
        }
    }

}
