/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.converter;

import cn.ac.csns.portal.proposalsystem.entity.FacilityCycle;
import cn.ac.csns.portal.proposalsystem.managed.AppDataController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.inject.Named;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@RequestScoped
public class FacilityCycleConverter implements Converter {

    @Inject
    private AppDataController appData;   
    
    private FacilityCycle getFacilityCycleById(Long id) {
        for (FacilityCycle fc : appData.getFacilityCycles()) {
            if (fc.getId().equals(id)) {
                return fc;
            }
        }
        return null;
    }

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (value != null && !value.trim().isEmpty()) {
            try {
                //return service.find(Long.parseLong(value));
                return getFacilityCycleById(Long.parseLong(value));
            } catch (NumberFormatException ex) {
                Logger.getLogger(FacilityCycleConverter.class.getName())
                        .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                FacesContext.getCurrentInstance().addMessage(null,
                        new FacesMessage(FacesMessage.SEVERITY_FATAL,
                                ex.getLocalizedMessage(),
                                ex.getLocalizedMessage()));
                return null;
            }
        } else {
            return null;
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value != null && value instanceof FacilityCycle) {
            return String.valueOf(((FacilityCycle) value).getId());
        } else {
            return null;
        }
    }

}
