/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Investigation;
import cn.ac.csns.portal.proposalsystem.entity.InvestigationStatus;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.InvestigationFacade;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class CopyProposalController implements Serializable {

    private List<Investigation> investigations;
    private String currentUser;
    private Investigation current;
    private boolean includeSamples;
    private boolean includeStudies;
    private boolean includeMembers;
    private boolean includeAll;

    @EJB
    private InvestigationFacade facade;

    /**
     * Creates a new instance of CopyProposalController
     */
    public CopyProposalController() {
    }

    @PostConstruct
    private void init() {
        try {
            currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
            investigations = facade.findByCreator(currentUser)
                    .stream()
                    .filter(iv -> iv.getStatus().equals(InvestigationStatus.NEW))
                    .sorted((o1, o2) -> {
                        return o2.getCreateTime().compareTo(o1.getCreateTime());
                    })
                    .collect(Collectors.toList());
        } catch (IpsException ex) {
            investigations = new ArrayList<>();
            Logger.getLogger(SubmitProposalController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
    }

    public String doCopy() {
        try {
            facade.create(preSave());
            return "/index?faces-redirect=true";
        } catch (IpsException ex) {
            Logger.getLogger(CopyProposalController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            FacesContext.getCurrentInstance()
                    .addMessage(null,
                            new FacesMessage(FacesMessage.SEVERITY_FATAL,
                                    "Error while copy proposal", ex.getLocalizedMessage()));
            return "";
        }

    }

    private Investigation preSave() {
        Investigation temp = new Investigation();
        Date now = new Date();
        temp.setCreateId(currentUser);
        temp.setCreateTime(now);
        temp.setModId(currentUser);
        temp.setModTime(now);
        temp.setSummary(current.getSummary());
        temp.setStatus(InvestigationStatus.NEW);
        temp.setFacility(current.getFacility());
        temp.setType(current.getType());
        temp.setFacilityCycle(current.getFacilityCycle());
        String prefix = "COPY_" + new SimpleDateFormat("yyyyMMddHHmmssZ").format(now) + "_";
        temp.setName(prefix + current.getName());
        temp.setTitle(current.getTitle());

        // Processing instruments
        temp.setInvestigationInstruments(current.getInvestigationInstruments());
        temp.getInvestigationInstruments().stream().forEach(ii -> {
            ii.setId(null);
            ii.setInvestigation(temp);
            ii.setCreateId(currentUser);
            ii.setCreateTime(now);
            ii.setModId(currentUser);
            ii.setModTime(now);
        });

        // Processing keywords
        temp.setKeywords(current.getKeywords());
        temp.getKeywords().stream().forEach(k -> {
            k.setInvestigation(temp);
            k.setId(null);
            k.setCreateId(currentUser);
            k.setCreateTime(now);
            k.setModId(currentUser);
            k.setModTime(now);
        });

        if (includeMembers) {
            temp.setInvestigationGroups(current.getInvestigationGroups());
            temp.getInvestigationGroups().stream().forEach(ig -> {
                ig.setId(null);
                ig.setInvestigation(temp);
                ig.setCreateId(currentUser);
                ig.setCreateTime(now);
                ig.setModId(currentUser);
                ig.setModTime(now);
            });

            temp.setInvestigationUsers(current.getInvestigationUsers());
            temp.getInvestigationUsers().stream().forEach(iu -> {
                iu.setId(null);
                iu.setInvestigation(temp);
                iu.setCreateId(currentUser);
                iu.setCreateTime(now);
                iu.setModId(currentUser);
                iu.setModTime(now);
            });
        }
        if (includeSamples) {
            temp.setSamples(current.getSamples());
            temp.getSamples().stream().forEach(s -> {
                s.setId(null);
                s.setInvestigation(temp);
                s.setCreateTime(now);
                s.setCreateId(currentUser);
                s.setModId(currentUser);
                s.setModTime(now);
            });
        }
        if (includeStudies) {
            temp.setStudyInvestigations(current.getStudyInvestigations());
            temp.getStudyInvestigations().stream().forEach(si -> {
                si.setId(null);
                si.setInvestigation(temp);
                si.setCreateTime(now);
                si.setCreateId(currentUser);
                si.setModId(currentUser);
                si.setModTime(now);
            });
        }
        return temp;
    }

    public void onAllChanged() {
        if (includeAll) {
            includeMembers = true;
            includeSamples = true;
            includeStudies = true;
        } else {
            includeMembers = false;
            includeSamples = false;
            includeStudies = false;
        }
    }

    public void onSingleChanged() {
        includeAll = includeMembers && includeSamples && includeStudies;
    }

    public List<Investigation> getInvestigations() {
        return investigations;
    }

    public Investigation getCurrent() {
        return current;
    }

    public void setCurrent(Investigation current) {
        this.current = current;
    }

    public boolean isIncludeSamples() {
        return includeSamples;
    }

    public void setIncludeSamples(boolean includeSamples) {
        this.includeSamples = includeSamples;
    }

    public boolean isIncludeStudies() {
        return includeStudies;
    }

    public void setIncludeStudies(boolean includeStudies) {
        this.includeStudies = includeStudies;
    }

    public boolean isIncludeMembers() {
        return includeMembers;
    }

    public void setIncludeMembers(boolean includeMembers) {
        this.includeMembers = includeMembers;
    }

    public boolean isIncludeAll() {
        return includeAll;
    }

    public void setIncludeAll(boolean includeAll) {
        this.includeAll = includeAll;
    }

}
