/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.exception;

import javax.ejb.ApplicationException;

/**
 * The base class for integrated proposal system exceptions.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@ApplicationException(rollback = true)
public class IpsException extends Exception {

    /**
     * The type of the IpsException.
     */
    public enum IpsExceptionType {
        /**
         * Input parameters appear to be incorrect.
         */
        BAD_PARAMETER,
        /**
         * Internal error.
         */
        INTERNAL,
        /**
         * Authorization problem.
         */
        INSUFFICIENT_PRIVILEGES,
        /**
         * The requested object does not exist.
         */
        NO_SUCH_OBJECT_FOUND,
        /**
         * An object already exists.
         */
        OBJECT_ALREADY_EXISTS,
        /**
         * An authentication problem or the session has expired.
         */
        SESSION,
        /**
         * The call is not appropriate.
         */
        VALIDATION,
        /**
         * No implementation is provided.
         */
        NOT_IMPLEMENTED,
        /**
         * Transaction roll back failure.
         */
        ROLL_BACK
    }

    private IpsExceptionType type;

    /**
     * Constructs an instance of <code>IpsException</code> with the specified
     * type and detail message.
     *
     * @param type the type of the IpsException.
     * @param msg the detail message.
     */
    public IpsException(IpsExceptionType type, String msg) {
        super(msg);
        this.type = type;
    }

    /**
     * Constructs an instance of <code>IpsException</code> with the specified
     * type, detail message and cause.
     *
     * @param type the type of the IpsException.
     * @param message the detail message.
     * @param cause the cause.
     */
    public IpsException(IpsExceptionType type, String message, Throwable cause) {
        super(message, cause);
        this.type = type;
    }

    /**
     * Constructs an instance of <code>IpsException</code> with the specified
     * type and cause.
     *
     * @param type the type of the IpsException.
     * @param cause the cause.
     */
    public IpsException(IpsExceptionType type, Throwable cause) {
        super(cause);
        this.type = type;
    }

    @Override
    public String toString() {
        return type + " " + super.toString();
    }

    /**
     * Get the type of the IpsException
     *
     * @return the value of type
     */
    public IpsExceptionType getType() {
        return type;
    }

    /**
     * Set the type of the IpsException
     *
     * @param type new value of type
     */
    public void setType(IpsExceptionType type) {
        this.type = type;
    }
}
