package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Sample;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.primefaces.context.RequestContext;

/**
 * Add a sample.
 *
 * @author tangm
 */
@Named
@ViewScoped
public class AddSampleController implements Serializable {

    private Sample newSample;

    /**
     * Creates a new instance of AddSampleManagedBean
     */
    public AddSampleController() {
        String currentUser = FacesContext.getCurrentInstance()
                .getExternalContext().getRemoteUser();
        Date now = new Date();
        newSample = new Sample();
        newSample.setCreateId(currentUser);
        newSample.setCreateTime(now);
        newSample.setModId(currentUser);
        newSample.setModTime(now);
        newSample.setQuantity(1);
    }

    public void openAddSampleDialog() {
        Map<String, Object> options = new HashMap<>();
        options.put("modal", true);
        options.put("draggable", true);
        options.put("resizable", true);
        //options.put("width", 340);
        options.put("height", 340);
        options.put("contentHeight", "100%");
        options.put("contentWidth", "100%");
        RequestContext.getCurrentInstance().openDialog("addsample", options, null);
    }

    public void addSample() {
        RequestContext.getCurrentInstance().closeDialog(newSample);
    }

    public void cancle() {
        RequestContext.getCurrentInstance().closeDialog(null);
    }

    public Sample getNewSample() {
        return newSample;
    }

    public void setNewSample(Sample newSample) {
        this.newSample = newSample;
    }

}
