/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.facade;

import cn.ac.csns.portal.proposalsystem.entity.UserGroup;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Stateless
public class UserGroupFacade extends AbstractFacade<UserGroup> {

    @PersistenceContext
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public UserGroupFacade() {
        super(UserGroup.class);
    }

    public List<UserGroup> findByUserName(String userName) throws IpsException {
        String jpqlString = "SELECT ug FROM UserGroup ug where ug.user.name = :userName";
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("userName", userName);
        return findResultListByQuery(jpqlString, parameters);
    }

    public List<UserGroup> findByCreator(String createId) throws IpsException {
        String jpqlString = "SELECT ug FROM UserGroup ug where ug.createId = :createId";
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("createId", createId);
        return findResultListByQuery(jpqlString, parameters);
    }

}
