/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.facade;

import cn.ac.csns.portal.proposalsystem.entity.Grouping;
import cn.ac.csns.portal.proposalsystem.entity.User;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 * The session facade for Grouping entity.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Stateless
public class GroupingFacade extends AbstractFacade<Grouping> {

    @PersistenceContext
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public GroupingFacade() {
        super(Grouping.class);
    }

    /**
     * Find a group by the unique name.
     *
     * @param name the unique name of the group
     * @return a group
     * @throws IpsException if find fails
     */
    public Grouping findByName(String name) throws IpsException {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("name", name);
        return findSingleResultByNamedQuery(Grouping.FIND_BY_NAME, parameters);
    }

    /**
     * Find all groups of the user.
     *
     * @param user the User instance
     * @return a list of groups
     * @throws IpsException if find fails
     */
    public List<Grouping> findByUser(User user) throws IpsException {
        String jpqlQuery = "SELECT g FROM Grouping g JOIN g.userGroups ug WHERE ug.user = :user";
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("user", user);
        return findResultListByQuery(jpqlQuery, parameters);
    }

    public List<Grouping> findByCreator(String createId) throws IpsException {
        String jpqlString = "SELECT g FROM Grouping g where g.createId = :createId";
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("createId", createId);
        return findResultListByQuery(jpqlString, parameters);
    }

}
