/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.FacilityCycle;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.FacilityCycleFacade;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class FacilityCycleController implements Serializable {

    private FacilityCycle current;

    @Inject
    private AppDataController appData;

    @EJB
    private FacilityCycleFacade facade;

    /**
     * Creates a new instance of FacilityController
     */
    public FacilityCycleController() {
        current = new FacilityCycle();
    }

    @Transactional
    public void add() {
        Date now = new Date();
        String currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        current.setCreateId(currentUser);
        current.setCreateTime(now);
        current.setModId(currentUser);
        current.setModTime(now);
        String message;
        try {
            facade.create(current);
            facade.flush();
            appData.freshFacilityCycles();
            message = "Facility cycle added successfully.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            Logger.getLogger(FacilityCycleController.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
            message = "Error occured when add facility cycle.";
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
        current = new FacilityCycle();
    }

    public void remove(FacilityCycle investigationType) {
        String message;
        try {
            facade.remove(investigationType);
            appData.freshFacilityCycles();
            message = "Facility cycle removed: " + investigationType.getName();
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
        } catch (IpsException ex) {
            message = "Error occurred when remove facility cycle: " + investigationType.getName();
            Logger.getLogger(FacilityCycleController.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public FacilityCycle getCurrent() {
        return current;
    }

    public void setCurrent(FacilityCycle current) {
        this.current = current;
    }

}
