/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.managed;

import cn.ac.csns.portal.proposalsystem.entity.Investigation;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.facade.InvestigationFacade;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.inject.Named;
import javax.faces.view.ViewScoped;

/**
 * Controller for list proposals.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Named
@ViewScoped
public class ListProposalController implements Serializable {

    private List<Investigation> investigations;
    private List<Investigation> filteredInvestigations;
    private String currentUser;

    @EJB
    private InvestigationFacade facade;

    /**
     * Creates a new instance of ListProposalController
     */
    public ListProposalController() {
        investigations = new ArrayList<>();
    }

    @PostConstruct
    private void init() {
        currentUser = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
        try {
            investigations = facade.findByCreator(currentUser)
                    .stream()
                    .sorted((o1, o2) -> {
                        return o2.getCreateTime().compareTo(o1.getCreateTime());
                    })
                    .collect(Collectors.toList());
        } catch (IpsException ex) {
            String message = "Error occurred while retriving investigations.";
            Logger.getLogger(ListProposalController.class.getName())
                    .log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            FacesContext.getCurrentInstance().addMessage(null,
                    new FacesMessage(FacesMessage.SEVERITY_FATAL, message, message));
        }
    }

    public String doView(Investigation investigation) {
        Flash flash = FacesContext.getCurrentInstance().getExternalContext().getFlash();
        flash.put("currentInvestigation", investigation);
        return "/viewproposal?faces-redirect=true";
    }

    public List<Investigation> getInvestigations() {
        return investigations;
    }

    public List<Investigation> getFilteredInvestigations() {
        return filteredInvestigations;
    }

    public void setFilteredInvestigations(List<Investigation> filteredInvestigations) {
        this.filteredInvestigations = filteredInvestigations;
    }

}
