/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.facade;

import cn.ac.csns.portal.proposalsystem.entity.Investigation;
import cn.ac.csns.portal.proposalsystem.entity.User;
import cn.ac.csns.portal.proposalsystem.exception.IpsException;
import cn.ac.csns.portal.proposalsystem.exception.IpsException.IpsExceptionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;

/**
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Stateless
public class InvestigationFacade extends AbstractFacade<Investigation> {

    @PersistenceContext
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public InvestigationFacade() {
        super(Investigation.class);
    }

    /**
     * Find by primary key. Search for an entity of the specified class and
     * primary key. If the entity instance is contained in the persistence
     * context, it is returned from there.
     *
     * @param id primary key
     * @param hint a hint to the entity graph type. Can be
     * "<code>javax.persistence.fetchgraph</code>" or
     * "<code>javax.persistence.loadgraph</code>". GlassFish does not support
     * "<code>javax.persistence.loadgraph</code>".
     * @param graphName the the name of the named entity graph
     * @return the found entity instance
     * @throws IpsException if id is not a valid primary key
     */
    public Investigation findById(Long id, String hint, String graphName) throws IpsException {
        try {
            String jpqlQuery = "SELECT i FROM Investigation i WHERE i.id = :id";
            TypedQuery<Investigation> tq = getEntityManager().createQuery(jpqlQuery, Investigation.class);
            tq.setParameter("id", id);
            if (null != hint && null != graphName) {
                tq.setHint(hint, getEntityManager().getEntityGraph(graphName));
            }
            return tq.getSingleResult();
        } catch (IllegalArgumentException ex) {
            throw new IpsException(IpsExceptionType.BAD_PARAMETER,
                    ex.getLocalizedMessage());
        } catch (NoResultException ex) {
            throw new IpsException(IpsExceptionType.NO_SUCH_OBJECT_FOUND,
                    ex.getLocalizedMessage());
        } catch (Exception ex) {
            throw new IpsException(IpsExceptionType.INTERNAL,
                    ex.getLocalizedMessage());
        }
    }

    /**
     * Find all {@link Investigation} instances.
     *
     * @param hint a hint to the entity graph type. Can be
     * "<code>javax.persistence.fetchgraph</code>" or
     * "<code>javax.persistence.loadgraph</code>". GlassFish does not support
     * "<code>javax.persistence.loadgraph</code>".
     * @param graphName the the name of the named entity graph
     * @return a list of Investigation instances
     * @throws IpsException if the find fails
     */
    public List<Investigation> findAll(String hint, String graphName)
            throws IpsException {
        try {
            CriteriaQuery<Investigation> cq = getEntityManager().getCriteriaBuilder()
                    .createQuery(Investigation.class);
            cq.select(cq.from(Investigation.class));
            TypedQuery<Investigation> tq = getEntityManager().createQuery(cq);
            if (null != hint && null != graphName) {
                tq.setHint(hint, getEntityManager().getEntityGraph(graphName));
            }
            return tq.getResultList();
        } catch (IllegalArgumentException ex) {
            throw new IpsException(IpsExceptionType.BAD_PARAMETER, ex.getLocalizedMessage());
        } catch (Exception ex) {
            throw new IpsException(IpsExceptionType.INTERNAL, ex.getLocalizedMessage());
        }
    }

    /**
     * Find investigation by title.
     *
     * @param title the investigation title
     * @param hint a hint to the entity graph type. Can be
     * "<code>javax.persistence.fetchgraph</code>" or
     * "<code>javax.persistence.loadgraph</code>". GlassFish does not support
     * "<code>javax.persistence.loadgraph</code>".
     * @param graphName the the name of the named entity graph
     * @return the found entity instance
     * @throws IpsException if title is not a valid primary key
     */
    public Investigation findByTitle(String title, String hint, String graphName) throws IpsException {
        try {
            TypedQuery<Investigation> tq = getEntityManager()
                    .createNamedQuery(Investigation.FIND_BY_TITLE, Investigation.class);
            tq.setParameter("title", title);
            if (null != hint && null != graphName) {
                tq.setHint(hint, getEntityManager().getEntityGraph(graphName));
            }
            return tq.getSingleResult();
        } catch (IllegalArgumentException ex) {
            throw new IpsException(IpsExceptionType.BAD_PARAMETER,
                    ex.getLocalizedMessage());
        } catch (NoResultException ex) {
            throw new IpsException(IpsExceptionType.NO_SUCH_OBJECT_FOUND,
                    ex.getLocalizedMessage());
        } catch (Exception ex) {
            throw new IpsException(IpsExceptionType.INTERNAL,
                    ex.getLocalizedMessage());
        }
    }

    /**
     * Find all investigations where an user is in the investigation members.
     * 
     * @param user the user
     * @return a list of investigations.
     * @throws IpsException 
     */
    public List<Investigation> findByUser(User user) throws IpsException {
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("user", user);
        return findResultListByNamedQuery(Investigation.FIND_BY_USER, parameters);
    }

    /**
     * Find all investigations where an user is in the investigation members.
     * 
     * @param userName the user name
     * @return a list of investigations.
     * @throws IpsException 
     */
    public List<Investigation> findByUserName(String userName) throws IpsException {
        String jpqlStr = "SELECT i FROM Investigation i JOIN i.investigationUsers iu"
                + " JOIN iu.user u WHERE u.name = :userName";
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("userName", userName);
        return findResultListByQuery(jpqlStr, parameters);
    }
    
    /**
     * Find all investigations created by the creator.
     * @param creatorId the id of the creator
     * @return a list of investigations.
     * @throws IpsException 
     */
    public List<Investigation> findByCreator(String creatorId) throws IpsException {        
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("createId", creatorId);
        return findResultListByNamedQuery(Investigation.FIND_BY_CREATE_ID, parameters);
    }

}
