/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * A review of an investigation.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@NamedQueries({
    @NamedQuery(name = "Review.findByUser",
            query = "SELECT r FROM Review r WHERE r.user = :user"),
    @NamedQuery(name = "Review.findByInvestigation",
            query = "SELECT r FROM Review r WHERE r.investigation = :investigation"),
    @NamedQuery(name = "Review.findByParent",
            query = "SELECT r FROM Review r WHERE r.parent = :parent")})
public class Review extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_USER = "Review.findByUser";
    public static final String FIND_BY_INVESTIGATION = "Review.findByInvestigation";
    public static final String FIND_BY_PARENT = "Review.findByParent";

    /**
     * The title of a review.
     */
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(nullable = false)
    private String title;

    /**
     * The details of a review.
     */
    @Basic(optional = false)
    @NotNull
    @Size(max = 2000)
    @Column(length = 2000)
    private String content;

    @ManyToOne
    private Review parent;

    @OneToMany(mappedBy = "parent")
    private List<Review> children;

    /**
     * The author of the review.
     */
    @ManyToOne
    @JoinColumn(name = "USER_ID", nullable = false)
    private User user;

    /**
     * The investigation which this review attached to.
     */
    @ManyToOne
    @JoinColumn(name = "INVESTIGATION_ID", nullable = false)
    private Investigation investigation;

    public Review() {
        children = new ArrayList<>();
    }

    /**
     * Get the value of investigation
     *
     * @return the value of investigation
     */
    public Investigation getInvestigation() {
        return investigation;
    }

    /**
     * Set the value of investigation
     *
     * @param investigation new value of investigation
     */
    public void setInvestigation(Investigation investigation) {
        this.investigation = investigation;
    }

    /**
     * Get the value of user
     *
     * @return the value of user
     */
    public User getUser() {
        return user;
    }

    /**
     * Set the value of user
     *
     * @param user new value of user
     */
    public void setUser(User user) {
        this.user = user;
    }

    /**
     * Get the value of children
     *
     * @return the value of children
     */
    public List<Review> getChildren() {
        return children;
    }

    /**
     * Set the value of children
     *
     * @param children new value of children
     */
    public void setChildren(List<Review> children) {
        this.children = children;
    }

    /**
     * Get the value of parent
     *
     * @return the value of parent
     */
    public Review getParent() {
        return parent;
    }

    /**
     * Set the value of parent
     *
     * @param parent new value of parent
     */
    public void setParent(Review parent) {
        this.parent = parent;
    }

    /**
     * Get the value of content
     *
     * @return the value of content
     */
    public String getContent() {
        return content;
    }

    /**
     * Set the value of content
     *
     * @param content new value of content
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * Get the value of title
     *
     * @return the value of title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Set the value of title
     *
     * @param title new value of title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Review)) {
            return false;
        }
        Review other = (Review) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + " ]";
    }

}
