/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

/**
 * A review expert.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@NamedQueries({
    @NamedQuery(name = "Expert.findByUser", query = "SELECT e FROM Expert e WHERE e.user = :user"),
    @NamedQuery(name = "Expert.findByUserName", query = "SELECT e FROM Expert e WHERE e.user.name = :name")})
public class Expert extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_USER = "Expert.findByUser";
    public static final String FIND_BY_USER_NAME = "Expert.findByUserName";

    @OneToOne
    @JoinColumn(name = "USER_ID", nullable = false, unique = true)
    private User user;

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "expert")
    private List<ExpertInvestigation> expertInvestigations;

    // TODO: add properties as needed.
    public Expert() {
        expertInvestigations = new ArrayList<>();
    }

    /**
     * Get the value of expertInvestigations
     *
     * @return the value of expertInvestigations
     */
    public List<ExpertInvestigation> getExpertInvestigations() {
        return expertInvestigations;
    }

    /**
     * Set the value of expertInvestigations
     *
     * @param expertInvestigations new value of expertInvestigations
     */
    public void setExpertInvestigations(List<ExpertInvestigation> expertInvestigations) {
        this.expertInvestigations = expertInvestigations;
    }

    /**
     * Get the value of user
     *
     * @return the value of user
     */
    public User getUser() {
        return user;
    }

    /**
     * Set the value of user
     *
     * @param user new value of user
     */
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Expert)) {
            return false;
        }
        Expert other = (Expert) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + " ]";
    }

}
