/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cn.ac.csns.portal.proposalsystem.entity;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;

/**
 * Represents an expert assigned to review an investigation.
 *
 * @author tangm <a href="mailto:tangm@ihep.ac.cn">Tang Ming</a>
 */
@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"EXPERT_ID", "INVESTIGATION_ID"})})
@NamedQueries({
    @NamedQuery(name = "ExpertInvestigation.findByReviewConclusion",
            query = "SELECT ei FROM ExpertInvestigation ei WHERE ei.conclusion = :conclusion"),
    @NamedQuery(name = "ExpertInvestigation.findByExpert",
            query = "SELECT ei FROM ExpertInvestigation ei WHERE ei.expert = :expert"),
    @NamedQuery(name = "ExpertInvestigation.findByInvestigation",
            query = "SELECT ei FROM ExpertInvestigation ei WHERE ei.investigation = :investigation")})
public class ExpertInvestigation extends EntityBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String FIND_BY_REVIEW_CONCLUSION = "ExpertInvestigation.findByReviewConclusion";
    public static final String FIND_BY_EXPERT = "ExpertInvestigation.findByExpert";
    public static final String FIND_BY_INVESTIGATION = "ExpertInvestigation.findByInvestigation";

    @Basic(optional = false)
    @NotNull
    @Column(nullable = false, length = 12)
    @Enumerated(EnumType.STRING)
    private ReviewConclusion conclusion;

    @ManyToOne
    @JoinColumn(name = "EXPERT_ID", nullable = false)
    private Expert expert;

    @ManyToOne
    @JoinColumn(name = "INVESTIGATION_ID", nullable = false)
    private Investigation investigation;

    public ExpertInvestigation() {
    }

    /**
     * Get the value of investigation
     *
     * @return the value of investigation
     */
    public Investigation getInvestigation() {
        return investigation;
    }

    /**
     * Set the value of investigation
     *
     * @param investigation new value of investigation
     */
    public void setInvestigation(Investigation investigation) {
        this.investigation = investigation;
    }

    /**
     * Get the value of expert
     *
     * @return the value of expert
     */
    public Expert getExpert() {
        return expert;
    }

    /**
     * Set the value of expert
     *
     * @param expert new value of expert
     */
    public void setExpert(Expert expert) {
        this.expert = expert;
    }

    /**
     * Get the value of conclusion
     *
     * @return the value of conclusion
     */
    public ReviewConclusion getConclusion() {
        return conclusion;
    }

    /**
     * Set the value of conclusion
     *
     * @param conclusion new value of conclusion
     */
    public void setConclusion(ReviewConclusion conclusion) {
        this.conclusion = conclusion;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof ExpertInvestigation)) {
            return false;
        }
        ExpertInvestigation other = (ExpertInvestigation) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ id=" + id + " ]";
    }

}
