package cn.ac.csns.icat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author lanjian
 */
public class AppHelper {

    public static Properties getProperties() {
        File file = new File(AppHelper.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return loadProperties(file.getParent() + "/conf/global.properties");
    }

    public static Properties loadProperties(String propertiesFile) {
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(propertiesFile)) {
            props.load(in);
            in.close();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        } catch (IOException ex) {
            Logger.getLogger(App.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        return props;
    }
}
