package cn.ac.csns.icat;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

/**
 *
 * @author lanjian
 */
public class App {

    private final static String[] ARGS_AVAILABLE = {"RULE"};

    public static void help() {
        File file = new File(App.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        Properties globalProps = AppHelper.getProperties();
        String appPackageName = globalProps.getProperty("app.package.name", "icat-util-xxx.jar");
        System.out.println("Usage: ");
        System.out.println("    java -jar " + appPackageName + " ARG");
        System.out.println("Where ARG can be:");
        System.out.println("    rule        Generate CSNS default data policy rules");

        System.out.println("Press any key to continue...");
        try {
            System.in.read();
        } catch (IOException ex) {
        }
    }

    private static boolean checkArgs(String[] args) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            if (arg.trim().equalsIgnoreCase("help")) {
                return false;
            }
        }
        for (String validArg : ARGS_AVAILABLE) {
            if (args[0].trim().equalsIgnoreCase(validArg)) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (!checkArgs(args)) {
            help();
            return;
        }
        switch (args[0]) {
            case "rule":
                DataPolicyManager policyManager = new DataPolicyManager();
                policyManager.run();
                break;
            default:
                help();
        }
    }
}
